/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class DataPacket
extends Packet
implements SQLnetDef {
    static final boolean DEBUG2 = false;
    protected int pktOffset;
    protected int dataFlags;
    protected boolean isBufferFull = false;
    protected boolean isBufferEmpty = false;
    protected int availableBytesToSend = 0;
    protected int availableBytesToRead = 0;
    protected int sessionIdSize = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public DataPacket(SessionAtts sAtts, int len) {
        super(sAtts, len, 6, sAtts.poolEnabled ? 1 : 0);
        this.initialize(len);
    }

    public DataPacket(SessionAtts sAtts) {
        this(sAtts, sAtts.getSDU());
    }

    @Override
    protected void receive() throws IOException, NetException {
        super.receive();
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = this.length - this.dataOff - (this.sAtts.poolEnabled ? 16 : 0);
        this.dataFlags = this.buffer[8] & 0xFF;
        this.dataFlags <<= 8;
        this.dataFlags |= this.buffer[9] & 0xFF;
        if (this.type == 6 && (this.dataFlags & 0x40) != 0) {
            this.sAtts.dataEOF = true;
        }
        if (this.type == 6 && 0 == this.dataLen) {
            this.type = 7;
        }
        if (this.sAtts.poolEnabled) {
            this.sAtts.timestampLastIO = System.currentTimeMillis();
        }
    }

    @Override
    protected void send() throws IOException {
        this.send(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(int dataFlags) throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DataPacket.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.buffer[8] = (byte)(dataFlags / 256);
            this.buffer[9] = (byte)(dataFlags % 256);
            this.setBufferLength(this.pktOffset);
            OutputStream outputStream = this.sAtts.ntOutputStream;
            synchronized (outputStream) {
                block27: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            DataPacket.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Packet size=" + this.pktOffset + "\n" + this.dumpBytes(this.buffer, 0, this.pktOffset), this.sAtts.traceId);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.sAtts.poolEnabled) {
                        while (true) {
                            try {
                                this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
                                break block27;
                            }
                            catch (SocketException ea) {
                                if (!"Connection reset".equals(ea.getMessage()) && !"Connection reset by peer".equals(ea.getMessage()) || this.sAtts.attemptingReconnect) continue;
                                this.sAtts.ns.reconnectIfRequired(false);
                                continue;
                            }
                            break;
                        }
                    }
                    this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
                }
            }
            this.pktOffset = 10;
            this.availableBytesToSend = 0;
            this.isBufferFull = false;
            if (this.sAtts.poolEnabled) {
                this.sAtts.timestampLastIO = System.currentTimeMillis();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DataPacket.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected int putDataInBuffer(byte[] userBuffer, int off, int len) throws IOException {
        int bytes2copy;
        int n2 = bytes2copy = this.buffer.length - this.sessionIdSize - this.pktOffset <= len ? this.buffer.length - this.sessionIdSize - this.pktOffset : len;
        if (bytes2copy > 0) {
            System.arraycopy(userBuffer, off, this.buffer, this.pktOffset, bytes2copy);
            this.pktOffset += bytes2copy;
            this.isBufferFull = this.pktOffset == this.buffer.length - this.sessionIdSize;
            this.availableBytesToSend = this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0;
        }
        return bytes2copy;
    }

    protected int getDataFromBuffer(byte[] userBuffer, int off, int len) throws NetException {
        int bytes2copy;
        int n2 = bytes2copy = this.availableBytesToRead <= len ? this.availableBytesToRead : len;
        if (bytes2copy > 0) {
            System.arraycopy(this.buffer, this.pktOffset, userBuffer, off, bytes2copy);
            this.pktOffset += bytes2copy;
            this.isBufferEmpty = this.pktOffset == this.length;
            this.availableBytesToRead -= bytes2copy;
        }
        return bytes2copy;
    }

    protected void setBufferLength(int length) throws NetException {
        if (this.sAtts.poolEnabled) {
            System.arraycopy(this.sAtts.sessionId, 0, this.buffer, this.pktOffset, 16);
            length += 16;
            this.pktOffset += 16;
        }
        this.buffer[0] = (byte)(length / 256);
        this.buffer[1] = (byte)(length % 256);
    }

    protected void initialize(int bufferSize) {
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = bufferSize - this.dataOff;
        this.dataFlags = 0;
        this.sessionIdSize = this.sAtts.poolEnabled ? 16 : 0;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.net.ns");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.net.ns.Packet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

