/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.net.ano.Ano;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.AcceptPacket;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.ConnectPacket;
import oracle.net.ns.DataPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.Packet;
import oracle.net.ns.RedirectPacket;
import oracle.net.ns.RefusePacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.resolver.AddrResolution;

public class NSProtocol
implements Communication,
SQLnetDef {
    private static final boolean ACTIVATE_ANO = true;
    private AddrResolution addrRes;
    private SessionAtts sAtts = new SessionAtts(this, 65535, 65535);
    private MarkerPacket mkPkt;
    private DataPacket probePacket;
    private Packet packet;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public NSProtocol() {
        this.sAtts.connected = false;
    }

    @Override
    public SessionAtts getSessionAttributes() {
        return this.sAtts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String connection, Properties userProperties) throws IOException, NetException {
        long __ol_nanos__ = 0L;
        try {
            RefusePacket rfPkt;
            RedirectPacket rdPkt;
            AcceptPacket acPkt;
            ConnectPacket cnPkt;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(userProperties));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.sAtts.connected) {
                throw new NetException(201);
            }
            if (connection == null) {
                throw new NetException(208);
            }
            NVFactory nvf = new NVFactory();
            NVNavigator nvn = new NVNavigator();
            NVPair errvp = null;
            String errCode = null;
            this.addrRes = new AddrResolution(connection, userProperties);
            String s2 = (String)userProperties.get("DISABLE_OOB");
            boolean disableOOB = s2 != null && "true".equals(s2);
            String s22 = (String)userProperties.get("USE_ZERO_COPY_IO");
            boolean useZeroCopyIO = true;
            if (s22 != null && "false".equals(s22)) {
                useZeroCopyIO = false;
            }
            this.sAtts.traceId = (String)userProperties.get("T4CConnection.hashCode");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Tracing T4CConnection.hashCode=" + this.sAtts.traceId, this.sAtts.traceId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.addrRes.connection_revised) {
                connection = this.addrRes.getTNSAddress();
                userProperties = this.addrRes.getUp();
            }
            this.sAtts.profile = new ClientProfile(userProperties);
            this.establishConnection(connection);
            Object objAno = null;
            try {
                objAno = Class.forName("oracle.net.ano.Ano").newInstance();
                this.sAtts.anoEnabled = true;
            }
            catch (Exception e2) {
                this.sAtts.anoEnabled = false;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "anoEnabled = " + this.sAtts.anoEnabled, this.sAtts.traceId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (objAno != null) {
                ((Ano)objAno).init(this.sAtts);
                this.sAtts.ano = objAno;
                this.sAtts.anoEnabled = true;
            }
            block47: while (true) {
                IOException stashedException = null;
                cnPkt = new ConnectPacket(this.sAtts, !disableOOB, useZeroCopyIO);
                this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
                try {
                    cnPkt.send();
                    this.packet.receive();
                }
                catch (InterruptedIOException ea) {
                    throw ea;
                }
                catch (IOException ea) {
                    this.packet.type = 4;
                    stashedException = ea;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Connect packet received, packet.type=" + this.packet.type, this.sAtts.traceId);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                switch (this.packet.type) {
                    case 2: {
                        acPkt = new AcceptPacket(this.packet);
                        if (!TRACE || !OracleLog.recursiveEnter()) break block47;
                        try {
                            NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Dumping Accept Packet:\n" + acPkt.toString(), this.sAtts.traceId);
                            break block47;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    case 5: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Got a message to redirect", this.sAtts.traceId);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        rdPkt = new RedirectPacket(this.packet);
                        ConnOption origConnOption = this.sAtts.cOption;
                        this.addrRes.connection_redirected = true;
                        this.sAtts.cOption.nt.disconnect();
                        this.sAtts = this.establishConnection(rdPkt.getData());
                        this.sAtts.cOption.restoreFromOrigCoption(origConnOption);
                        break;
                    }
                    case 4: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Connection refused !!!", this.sAtts.traceId);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        rfPkt = new RefusePacket(this.packet);
                        this.sAtts.cOption.nt.disconnect();
                        this.sAtts.cOption = null;
                        this.establishConnection(null);
                        if (this.sAtts.cOption != null) continue block47;
                        if (stashedException != null) {
                            throw stashedException;
                        }
                        try {
                            NVPair nvPair;
                            errvp = nvn.findNVPairRecurse(nvf.createNVPair(rfPkt.getData()), "ERROR");
                            if (errvp != null && (nvPair = nvn.findNVPairRecurse(errvp, "CODE")) != null) {
                                errCode = nvPair.valueToString();
                            }
                        }
                        catch (NLException exp) {
                            System.err.println(exp.getMessage());
                        }
                        throw new NetException(errCode == null ? 206 : Integer.parseInt(errCode), "");
                    }
                    case 11: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Got a message to resend the packet again.", this.sAtts.traceId);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if ((this.packet.flags & 8) != 8) continue block47;
                        this.sAtts.renegotiateSSLSession();
                        break;
                    }
                    default: {
                        this.sAtts.cOption.nt.disconnect();
                        throw new NetException(205);
                    }
                }
            }
            this.setNetStreams();
            this.sAtts.connected = true;
            this.sAtts.nt.setReadTimeoutIfRequired(userProperties);
            String verifyString = (String)this.sAtts.nt.getOption(6);
            if (verifyString != null && verifyString.equalsIgnoreCase("false")) {
                throw new NetException(405);
            }
            if (!this.sAtts.noAnoServices && this.sAtts.ano != null) {
                this.sAtts.ano.negotiation();
                String transportEncryptionEnabled = (String)this.sAtts.nt.getOption(2);
                if (transportEncryptionEnabled != null && transportEncryptionEnabled.equals("TRUE")) {
                    try {
                        Method getEncMethod = this.sAtts.ano.getClass().getMethod("getEncryptionAlg", null);
                        if (getEncMethod.invoke((Object)this.sAtts.ano, (Object[])null) != null) {
                            throw new NetException(406);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            this.packet = null;
            cnPkt = null;
            acPkt = null;
            rdPkt = null;
            rfPkt = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException ioException = null;
        try {
            this.sAtts.nsOutputStream.close();
        }
        catch (IOException ea) {
            ioException = ea;
        }
        this.sAtts.connected = false;
        this.sAtts.cOption.nt.disconnect();
        if (ioException != null) {
            throw ioException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBreak() throws IOException, NetException {
        block21: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Sending urgert marker '!'", this.sAtts.traceId);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.sAtts.nt.sendUrgentByte(33);
                    if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                        this.sendMarker(1);
                    }
                    break block21;
                }
                this.sendMarker(1);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendInterrupt() throws IOException, NetException {
        block21: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Sending urgert marker '!'", this.sAtts.traceId);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.sAtts.nt.sendUrgentByte(33);
                    if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                        this.sendMarker(3);
                    }
                    break block21;
                }
                this.sendMarker(3);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendReset() throws IOException, NetException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.sAtts.connected) {
                throw new NetException(200);
            }
            this.sendMarker(2);
            while (this.sAtts.onBreakReset) {
                Packet currentPacket = ((NetInputStream)this.sAtts.getInputStream()).getCurrentPacket();
                currentPacket.receive();
                if (currentPacket.type != 12) continue;
                this.mkPkt = new MarkerPacket(currentPacket);
                if (this.mkPkt.data != 2) continue;
                this.sAtts.onBreakReset = false;
            }
            this.mkPkt = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public NetInputStream getNetInputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsInputStream;
    }

    @Override
    public InputStream getInputStream() throws NetException {
        return this.getNetInputStream();
    }

    @Override
    public NetOutputStream getNetOutputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsOutputStream;
    }

    @Override
    public OutputStream getOutputStream() throws NetException {
        return this.getNetOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionAtts establishConnection(String connection) throws NetException, IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(connection));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.sAtts.cOption = this.addrRes.resolveAndExecute(connection);
            if (this.sAtts.cOption == null) {
                SessionAtts sessionAtts = null;
                return sessionAtts;
            }
            this.sAtts.nt = this.sAtts.cOption.nt;
            this.sAtts.ntInputStream = this.sAtts.cOption.nt.getInputStream();
            this.sAtts.ntOutputStream = this.sAtts.cOption.nt.getOutputStream();
            this.sAtts.setTDU(this.sAtts.cOption.tdu);
            this.sAtts.setSDU(this.sAtts.cOption.sdu);
            if (this.sAtts.attemptingReconnect) {
                this.sAtts.nsOutputStream.reinitialize(this.sAtts);
                this.sAtts.nsInputStream.reinitialize(this.sAtts);
                if (this.mkPkt != null) {
                    this.mkPkt.reinitialize(this.sAtts);
                }
            } else {
                this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts, 255);
                this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + this.sAtts.toString(), this.sAtts.traceId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SessionAtts sessionAtts = this.sAtts;
            return sessionAtts;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private void setNetStreams() throws NetException, IOException {
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMarker(int type) throws IOException, NetException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.sAtts.connected) {
                throw new NetException(200);
            }
            this.mkPkt = new MarkerPacket(this.sAtts, type);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Sending break marker", this.sAtts.traceId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.mkPkt.send();
            this.mkPkt = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public void setO3logSessionKey(byte[] sessionKey) throws NetException {
        if (sessionKey != null) {
            this.sAtts.ano.setO3logSessionKey(sessionKey);
        }
    }

    @Override
    public void setOption(int option, Object value) throws NetException, IOException {
        if (option > 0 && option < 10) {
            NTAdapter nt = this.sAtts.getNTAdapter();
            nt.setOption(option, value);
        }
    }

    @Override
    public Object getOption(int option) throws NetException, IOException {
        if (option > 0 && option < 10) {
            NTAdapter nt = this.sAtts.getNTAdapter();
            return nt.getOption(option);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws NetException, IOException {
        long __ol_nanos__ = 0L;
        try {
            NTAdapter nt;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((nt = this.sAtts.getNTAdapter()) != null) {
                nt.abort();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public String getEncryptionName() {
        String ret = null;
        NTAdapter ntadapter = this.sAtts.getNTAdapter();
        try {
            ret = (String)ntadapter.getOption(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null && this.sAtts.ano != null) {
            ret = this.sAtts.ano.getEncryptionName();
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    @Override
    public String getDataIntegrityName() {
        String ret = "";
        if (this.sAtts.ano != null) {
            ret = this.sAtts.ano.getDataIntegrityName();
        }
        return ret;
    }

    @Override
    public String getAuthenticationAdaptorName() {
        String ret = "";
        if (this.sAtts.ano != null) {
            ret = this.sAtts.ano.getAuthenticationAdaptorName();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnectIfRequired(boolean probe) throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(probe));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - this.sAtts.timestampLastIO;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "reconnectIfRequired: elapsedTime=" + elapsedTime + ", timeout=" + this.sAtts.timeout + (elapsedTime > (long)this.sAtts.timeout ? "Need to reconnect" : ""), this.sAtts.traceId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (elapsedTime > (long)this.sAtts.timeout) {
                this.reconnect(probe);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean probe) throws IOException {
        block23: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(probe));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    String reconnectAddress = new String(this.sAtts.reconnectAddress);
                    this.sAtts.attemptingReconnect = true;
                    ConnOption origConnOption = this.sAtts.cOption;
                    this.addrRes.connection_redirected = true;
                    this.sAtts.cOption.nt.disconnect();
                    this.establishConnection(reconnectAddress);
                    this.sAtts.cOption.restoreFromOrigCoption(origConnOption);
                    if (!probe) break block23;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NSProtocol.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Sending a probe packet", this.sAtts.traceId);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.probePacket == null) {
                        this.probePacket = new DataPacket(this.sAtts, 26);
                    } else {
                        this.probePacket.reinitialize(this.sAtts);
                    }
                    this.probePacket.send();
                }
                finally {
                    this.sAtts.attemptingReconnect = false;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NSProtocol.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.net.ns");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.net.ns.NSProtocol"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

