/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;

public class RefusePacket
extends Packet
implements SQLnetDef {
    protected int userReason;
    protected int systemReason;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefusePacket(Packet pkt) throws IOException, NetException {
        super(pkt);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefusePacket.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument("pkt=" + pkt));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.userReason = this.buffer[8];
            this.systemReason = this.buffer[9];
            this.dataOff = 12;
            this.dataLen = this.buffer[10] & 0xFF;
            this.dataLen <<= 8;
            this.dataLen |= this.buffer[11] & 0xFF;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefusePacket.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Displaying Refuse packet information:\n" + "reason=" + this.userReason + ", systemReason=" + this.systemReason + ", dataLen=" + this.dataLen, this.sAtts.traceId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.extractData();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RefusePacket.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.net.ns");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.net.ns.RefusePacket"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

