/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.Vector;
import oracle.net.jdbc.TNSAddress.Description;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavAddressList;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavDescription
extends Description
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int descProcessed;
    private boolean done = false;

    public NavDescription(SchemaObjectFactoryInterface fac) {
        super(fac);
    }

    @Override
    public void navigate(ConnStrategy cs, StringBuffer sBuf) {
        sBuf.setLength(0);
        sBuf.append("(DESCRIPTION=");
        try {
            if (this.SDU != null) {
                cs.sdu = Integer.parseInt(this.SDU);
            }
            if (this.TDU != null) {
                cs.tdu = Integer.parseInt(this.TDU);
            }
            if (this.connectTimeout != null) {
                cs.connectTimeout = Integer.parseInt(this.connectTimeout) * 1000;
            }
            if (this.retryCount != null) {
                cs.retryCount = Integer.parseInt(this.retryCount);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        cs.addSocketOptions(this.keepAlive);
        if (this.sourceRoute) {
            if (!this.backwardCompatibilityCase(this.children, cs)) {
                this.activeChildren = this.children;
                ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(cs, sBuf);
                for (int i2 = 1; i2 < this.activeChildren.size(); ++i2) {
                    ((NavSchemaObject)this.activeChildren.elementAt(i2)).addToString(cs);
                }
            } else {
                this.setConnectionOption(cs, sBuf);
            }
            this.closeNVPair(cs);
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (int i3 = 0; i3 < this.activeChildren.size(); ++i3) {
                ((NavSchemaObject)this.activeChildren.elementAt(i3)).navigate(cs, sBuf);
            }
            this.closeNVPair(cs);
        }
        this.done = true;
    }

    public void closeNVPair(ConnStrategy cs) {
        for (int i2 = cs.cOpts.size() - 1; i2 >= 0 && !((ConnOption)cs.cOpts.elementAt((int)i2)).done; --i2) {
            ConnOption connOpt = (ConnOption)cs.cOpts.elementAt(i2);
            if (this.sourceRoute) {
                connOpt.conn_data.append("(SOURCE_ROUTE=yes)");
            }
            if (this.connectData == null) {
                this.connectData = "(SERVICE_NAME=)";
            }
            connOpt.conn_data.append("(CONNECT_DATA=");
            connOpt.conn_data.append("(CID=(PROGRAM=");
            connOpt.conn_data.append(cs.getProgramName());
            connOpt.conn_data.append(")(HOST=__jdbc__)(USER=");
            connOpt.conn_data.append(cs.getOSUsername());
            connOpt.conn_data.append("))");
            connOpt.conn_data.append(this.connectData);
            connOpt.conn_data.append(")");
            if (this.SID != null) {
                connOpt.sid = this.SID;
            }
            if (this.serviceName != null) {
                connOpt.service_name = this.serviceName;
            }
            if (this.instanceName != null) {
                connOpt.instance_name = this.instanceName;
            }
            if (this.sslServerCertDN != null) {
                connOpt.sslServerCertDN = this.sslServerCertDN;
            }
            connOpt.conn_data.append(")");
            connOpt.done = true;
        }
    }

    @Override
    public void addToString(ConnStrategy cs) {
    }

    private boolean backwardCompatibilityCase(Vector children, ConnStrategy cs) {
        if (children.size() == 1 && ((NavSchemaObject)children.elementAt(0)).isA() == 1 && !((NavAddressList)children.elementAt((int)0)).sourceRoute) {
            NavAddressList addrl = (NavAddressList)children.elementAt(0);
            int numChildren = addrl.getChildrenSize();
            if (numChildren == 0) {
                return false;
            }
            for (int i2 = 0; i2 < numChildren; ++i2) {
                if (addrl.getChildrenType(i2) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setConnectionOption(ConnStrategy cs, StringBuffer sBuf) {
        sBuf.append("(ADDRESS_LIST=");
        NavAddressList addrl = (NavAddressList)this.children.elementAt(0);
        NavAddress first = addrl.getChild(0);
        int numChildren = addrl.getChildrenSize();
        first.navigate(cs, sBuf);
        for (int i2 = 1; i2 < numChildren; ++i2) {
            addrl.getChild(i2).addToString(cs);
        }
        ((ConnOption)cs.cOpts.elementAt((int)0)).conn_data.append(")");
    }
}

