/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

public class ANYDATA
implements ORAData {
    static final byte KAD_VSN = 1;
    static final byte KAD_VSN2 = 2;
    boolean isNull;
    byte[] data;
    TypeDescriptor type;
    boolean isREF = false;
    short serverCharsetId = 0;
    short serverNCharsetId = 0;
    OracleConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ANYDATA(TypeDescriptor _type, boolean _isNull, byte[] _data, boolean _isREF) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_type) + ", " + OracleLog.argument(_isNull) + ", " + OracleLog.argument(_data));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.type = _type;
            this.isNull = _isNull;
            this.data = _data;
            this.isREF = _isREF;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANYDATA(OPAQUE datum) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(datum));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] image = datum.getBytesValue();
            this.connection = datum.getPhysicalConnection();
            if (this.connection != null) {
                this.serverCharsetId = this.connection.getDbCsId();
                this.serverNCharsetId = this.connection.getNCharSet();
            }
            this.unpickle(image, 0);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int unpickle(byte[] pickledBytes, int offset) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            PickleContext context;
            byte version;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pickledBytes) + ", " + OracleLog.argument(offset));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((version = (context = new PickleContext(pickledBytes, offset)).readByte()) == 2) {
                context.skipBytes(4);
            }
            short[] rdbmsTypeCode = new short[1];
            this.type = TypeDescriptor.unpickleOpaqueTypeImage(context, this.connection, rdbmsTypeCode);
            this.isNull = context.readByte() != 0;
            if (!this.isNull) {
                int dataLength = (int)context.readUB4();
                this.data = context.readDataValue(dataLength);
            }
            this.isREF = rdbmsTypeCode[0] == 110;
            int ret = context.offset();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int pickle(byte[] buffer, int offset) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(offset));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            buffer[offset++] = 1;
            offset = this.type.pickleOpaqueTypeImage(buffer, offset, this.isREF);
            buffer[offset++] = this.isNull ? (byte)1 : 0;
            if (!this.isNull) {
                int dataLength = this.data.length;
                buffer[offset++] = (byte)((dataLength & 0xFF000000) >> 24 & 0xFF);
                buffer[offset++] = (byte)((dataLength & 0xFF0000) >> 16 & 0xFF);
                buffer[offset++] = (byte)((dataLength & 0xFF00) >> 8 & 0xFF);
                buffer[offset++] = (byte)(dataLength & 0xFF);
                System.arraycopy(this.data, 0, buffer, offset, dataLength);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + offset);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = offset;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getImageSize() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int imageSize = this.type.getOpaqueImageTypeSize() + 1 + 1;
            if (!this.isNull) {
                imageSize += 4 + this.data.length;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + imageSize);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = imageSize;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(Connection c2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.connection = (OracleConnection)c2;
            OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", c2);
            byte[] image = new byte[this.getImageSize()];
            this.pickle(image, 0);
            OPAQUE opq = new OPAQUE(desc, this.connection, image);
            opq.setShareBytes(opq.toBytes());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + opq);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OPAQUE oPAQUE = opq;
            return oPAQUE;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ANYDATA convertDatum(Datum datum) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(datum));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ANYDATA ret = null;
            if (datum instanceof STRUCT) {
                ret = new ANYDATA(((STRUCT)datum).getDescriptor(), false, ((STRUCT)datum).toBytes(), false);
            } else if (datum instanceof ARRAY) {
                ret = new ANYDATA(((ARRAY)datum).getDescriptor(), false, ((ARRAY)datum).toBytes(), false);
            } else if (datum instanceof REF) {
                ret = new ANYDATA(((REF)datum).getDescriptor(), false, ((REF)datum).getBytes(), true);
            } else if (datum instanceof OPAQUE) {
                ret = new ANYDATA(((OPAQUE)datum).getDescriptor(), false, ((OPAQUE)datum).toBytes(), false);
            } else {
                TypeDescriptor type = null;
                if (datum instanceof NUMBER) {
                    type = new TypeDescriptor(2);
                } else if (datum instanceof DATE) {
                    type = new TypeDescriptor(12);
                } else if (datum instanceof INTERVALDS) {
                    type = new TypeDescriptor(190);
                } else if (datum instanceof INTERVALYM) {
                    type = new TypeDescriptor(189);
                } else if (datum instanceof TIMESTAMPTZ) {
                    type = new TypeDescriptor(188);
                } else if (datum instanceof TIMESTAMPLTZ) {
                    type = new TypeDescriptor(232);
                } else if (datum instanceof TIMESTAMP) {
                    type = new TypeDescriptor(187);
                } else if (datum instanceof NCLOB) {
                    type = new TypeDescriptor(288);
                } else if (datum instanceof CLOB) {
                    type = new TypeDescriptor(112);
                } else if (datum instanceof BLOB) {
                    type = new TypeDescriptor(113);
                } else if (datum instanceof BFILE) {
                    type = new TypeDescriptor(114);
                } else if (datum instanceof RAW) {
                    type = new TypeDescriptor(95);
                } else if (datum instanceof BINARY_DOUBLE) {
                    type = new TypeDescriptor(101);
                } else if (datum instanceof BINARY_FLOAT) {
                    type = new TypeDescriptor(100);
                } else if (datum instanceof ROWID) {
                    type = new TypeDescriptor(104);
                } else if (datum instanceof CHAR) {
                    type = new TypeDescriptor(96);
                }
                if (datum instanceof ROWID) {
                    byte[] base64rowid = datum.shareBytes();
                    long[] riddef = InternalFactory.rowid2urowid(base64rowid, 0, base64rowid.length);
                    byte[] riddefBytes = new byte[]{1, (byte)((riddef[0] & 0xFFFFFFFFFF000000L) >> 24), (byte)((riddef[0] & 0xFF0000L) >> 16), (byte)((riddef[0] & 0xFF00L) >> 8), (byte)(riddef[0] & 0xFFL), (byte)((riddef[1] & 0xFF00L) >> 8), (byte)(riddef[1] & 0xFFL), (byte)((riddef[2] & 0xFFFFFFFFFF000000L) >> 24), (byte)((riddef[2] & 0xFF0000L) >> 16), (byte)((riddef[2] & 0xFF00L) >> 8), (byte)(riddef[2] & 0xFFL), (byte)((riddef[3] & 0xFF00L) >> 8), (byte)(riddef[3] & 0xFFL)};
                    ret = new ANYDATA(type, false, riddefBytes, false);
                } else {
                    ret = new ANYDATA(type, false, datum.shareBytes(), false);
                }
            }
            if (datum instanceof DatumWithConnection) {
                ret.connection = ((DatumWithConnection)datum).getInternalConnection();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ANYDATA aNYDATA = ret;
            return aNYDATA;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDescriptor getTypeDescriptor() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.type);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TypeDescriptor typeDescriptor = this.type;
            return typeDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.isNull);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.isNull;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.data);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.data;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public boolean isREF() {
        return this.isREF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValue() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.stringValue(this.connection));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.stringValue(this.connection);
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String stringValue(Connection _connection) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String ret = null;
            ret = "ANYDATA TypeCode: \"" + this.getTypeDescriptor().getTypeCodeName();
            if (this.isREF) {
                ret = ret + "(REF)";
            }
            ret = ret + "\" - ANYDATA Value: \"";
            Datum dd = this.accessDatum();
            boolean gotStringValueFromDataum = false;
            try {
                ret = ret + dd.stringValue();
                gotStringValueFromDataum = true;
            }
            catch (SQLException e2) {
                // empty catch block
            }
            if (!gotStringValueFromDataum) {
                if (!(this.type.getInternalTypeCode() != 108 && this.type.getInternalTypeCode() != 110 || this.type.isTransient())) {
                    ret = ret + ((StructDescriptor)this.type).getName() + "(...)";
                } else if (this.type.getInternalTypeCode() == 122 && !this.type.isTransient()) {
                    ret = ret + ((ArrayDescriptor)this.type).getName() + "(...)";
                } else {
                    switch (this.type.getInternalTypeCode()) {
                        case 113: {
                            int c2;
                            InputStream is = ((BLOB)dd).getBinaryStream();
                            String ret2 = "";
                            while ((c2 = is.read()) != -1) {
                                ret2 = ret2 + Integer.toHexString(c2);
                            }
                            ret = ret + ret2;
                            try {
                                is.close();
                            }
                            catch (IOException ioe2) {}
                            break;
                            catch (IOException ioe) {
                                try {
                                    is.close();
                                }
                                catch (IOException ioe2) {}
                                break;
                                catch (Throwable throwable) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException ioe2) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        case 188: {
                            if (_connection == null) {
                                ret = ret + "?";
                                break;
                            }
                            ret = ret + ((TIMESTAMPTZ)dd).stringValue(_connection);
                            break;
                        }
                        case 232: {
                            if (_connection == null) {
                                ret = ret + "?";
                                break;
                            }
                            ret = ret + ((TIMESTAMPLTZ)dd).stringValue(_connection);
                            break;
                        }
                        case 114: {
                            ret = ret + "bfile_dir=" + ((BFILE)dd).getDirAlias() + " bfile_name=" + ((BFILE)dd).getName();
                        }
                    }
                }
            }
            ret = ret + "\"";
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum accessDatum() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            Datum o2;
            block51: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                o2 = null;
                if (this.isNull) break block51;
                short internalTypeCode = this.type.getInternalTypeCode();
                switch (internalTypeCode) {
                    case 58: {
                        o2 = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    case 108: {
                        if (this.type instanceof OpaqueDescriptor) {
                            o2 = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                            break;
                        }
                        if (!this.isREF) {
                            o2 = new STRUCT((StructDescriptor)this.type, this.data, this.connection);
                            break;
                        }
                        o2 = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                        break;
                    }
                    case 122: {
                        o2 = new ARRAY((ArrayDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    case 110: {
                        o2 = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                        break;
                    }
                    case 2: {
                        o2 = new NUMBER(this.data);
                        break;
                    }
                    case 12: {
                        o2 = new DATE(this.data);
                        break;
                    }
                    case 190: {
                        o2 = new INTERVALDS(this.data);
                        break;
                    }
                    case 189: {
                        o2 = new INTERVALYM(this.data);
                        break;
                    }
                    case 188: {
                        o2 = new TIMESTAMPTZ(this.data);
                        break;
                    }
                    case 232: {
                        o2 = new TIMESTAMPLTZ(this.data);
                        break;
                    }
                    case 187: {
                        o2 = new TIMESTAMP(this.data);
                        break;
                    }
                    case 112: {
                        o2 = new CLOB(this.connection, this.data);
                        break;
                    }
                    case 288: {
                        o2 = new NCLOB(this.connection, this.data);
                        break;
                    }
                    case 113: {
                        o2 = new BLOB(this.connection, this.data);
                        break;
                    }
                    case 114: {
                        o2 = new BFILE(this.connection, this.data);
                        break;
                    }
                    case 95: {
                        o2 = new RAW(this.data);
                        break;
                    }
                    case 101: {
                        o2 = new BINARY_DOUBLE(this.data);
                        break;
                    }
                    case 100: {
                        o2 = new BINARY_FLOAT(this.data);
                        break;
                    }
                    case 104: {
                        long rba = ((long)this.data[1] & 0xFFL) << 24 | ((long)this.data[2] & 0xFFL) << 16 | ((long)this.data[3] & 0xFFL) << 8 | (long)this.data[4] & 0xFFL;
                        long partitionId = ((long)this.data[5] & 0xFFL) << 8 | (long)this.data[6] & 0xFFL;
                        long blockNumber = ((long)this.data[7] & 0xFFL) << 24 | ((long)this.data[8] & 0xFFL) << 16 | ((long)this.data[9] & 0xFFL) << 8 | (long)this.data[10] & 0xFFL;
                        long slotNumber = ((long)this.data[11] & 0xFFL) << 8 | (long)this.data[12] & 0xFFL;
                        long[] urowid = new long[]{rba, partitionId, blockNumber, slotNumber};
                        byte[] rowidBase64 = InternalFactory.urowid2rowid(urowid);
                        o2 = new ROWID(rowidBase64);
                        break;
                    }
                    case 1: 
                    case 9: 
                    case 96: {
                        if (this.serverCharsetId != 0) {
                            o2 = new CHAR(this.data, CharacterSet.make(this.serverCharsetId));
                            break;
                        }
                        o2 = new CHAR(this.data, null);
                        break;
                    }
                    case 286: 
                    case 287: {
                        if (this.serverNCharsetId != 0) {
                            o2 = new CHAR(this.data, CharacterSet.make(this.serverNCharsetId));
                            break;
                        }
                        o2 = new CHAR(this.data, null);
                        break;
                    }
                    default: {
                        String messageXXX = "internal typecode: " + internalTypeCode;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ANYDATA.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + messageXXX);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, messageXXX);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + o2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER nUMBER = o2;
            return nUMBER;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = this.connection;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ANYDATA.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.ANYDATA"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

