/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetJAEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterJAEUC";
    static final transient short MAX_7BIT = 127;
    static final transient short LEADINGCODE = 143;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetJAEUC(int oracleId, JdbcCharacterConverters charConverter) {
        block12: {
            super(oracleId, charConverter);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    CharacterSetJAEUC.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetJAEUC.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSetJAEUC getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetJAEUC.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (charConverter.getGroupId() == 2) {
                CharacterSetJAEUC __result__ = new CharacterSetJAEUC(oracleId, charConverter);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetJAEUC.logger().log(Level.FINER, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetJAEUC characterSetJAEUC = __result__;
                return characterSetJAEUC;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetJAEUC.logger().log(Level.FINER, "         Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharacterSetJAEUC characterSetJAEUC = null;
            return characterSetJAEUC;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetJAEUC.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetJAEUC.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(walker));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int c2 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (c2 > 127) {
                if (c2 != 143) {
                    if (walker.bytes.length > walker.next) {
                        c2 = c2 << 8 | walker.bytes[walker.next];
                        ++walker.next;
                    }
                } else {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        if (walker.bytes.length <= walker.next) continue;
                        c2 = c2 << 8 | walker.bytes[walker.next];
                        ++walker.next;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetJAEUC.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + c2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = c2;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetJAEUC.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetJAEUC.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int bytesToShift = 0;
            int bytesNeeded = 1;
            while (c2 >> bytesToShift != 0) {
                bytesToShift = (short)(bytesToShift + 8);
                bytesNeeded = (short)(bytesNeeded + 1);
            }
            CharacterSetJAEUC.need(buffer, bytesNeeded);
            while (bytesToShift >= 0) {
                buffer.bytes[buffer.next++] = (byte)(c2 >> bytesToShift & 0xFF);
                bytesToShift = (short)(bytesToShift - 8);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetJAEUC.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetJAEUC"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

