/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSet12Byte;
import oracle.sql.CharacterSet1Byte;
import oracle.sql.CharacterSet2ByteFixed;
import oracle.sql.CharacterSetGB18030;
import oracle.sql.CharacterSetJAEUC;
import oracle.sql.CharacterSetLCFixed;
import oracle.sql.CharacterSetSJIS;
import oracle.sql.CharacterSetShift;
import oracle.sql.CharacterSetZHTEUC;
import oracle.sql.converter.CharacterConverterFactory;
import oracle.sql.converter.CharacterConverterFactoryJDBC;
import oracle.sql.converter.JdbcCharacterConverters;

public abstract class CharacterSetWithConverter
extends CharacterSet {
    public static CharacterConverterFactory ccFactory = new CharacterConverterFactoryJDBC();
    JdbcCharacterConverters m_converter;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetWithConverter(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.m_converter = charConverter;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSet getInstance(int oracleId) {
        long __ol_nanos__ = 0L;
        try {
            JdbcCharacterConverters charConverter;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(oracleId));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((charConverter = ccFactory.make(oracleId)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSet characterSet = null;
                return characterSet;
            }
            CharacterSetWithConverter charSetInstance = null;
            charSetInstance = CharacterSet1Byte.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + charSetInstance);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSet1Byte characterSet1Byte = charSetInstance;
                return characterSet1Byte;
            }
            charSetInstance = CharacterSetSJIS.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + charSetInstance);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSetShift.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + charSetInstance);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSet2ByteFixed.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + charSetInstance);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSetGB18030.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + charSetInstance);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSet12Byte.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + charSetInstance);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSetJAEUC.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + charSetInstance);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            charSetInstance = CharacterSetZHTEUC.getInstance(oracleId, charConverter);
            if (charSetInstance != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + charSetInstance);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetWithConverter characterSetWithConverter = charSetInstance;
                return characterSetWithConverter;
            }
            CharacterSetLCFixed __result__ = CharacterSetLCFixed.getInstance(oracleId, charConverter);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharacterSetLCFixed characterSetLCFixed = __result__;
            return characterSetLCFixed;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLossyFrom(CharacterSet from) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = from.getOracleId() != this.getOracleId();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(source));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = source.getOracleId() == this.getOracleId();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = this.m_converter.toUnicodeStringWithReplacement(bytes, offset, count);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = this.m_converter.toUnicodeString(bytes, offset, count);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(String s2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] __result__ = this.m_converter.toOracleString(s2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convertWithReplacement(String s2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] __result__ = this.m_converter.toOracleStringWithReplacement(s2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from) + ", " + OracleLog.argument(source) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (from.getOracleId() == this.getOracleId()) {
                byte[] __result__ = CharacterSetWithConverter.useOrCopy(source, offset, count);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = __result__;
                return byArray;
            }
            byte[] __result__ = this.convert(from.toString(source, offset, count));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetWithConverter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetWithConverter"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

