/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.AttributeDescriptor;
import oracle.sql.TypeDescriptor;

class Kotad {
    static final int KOTADSIG = -1365573631;
    static final int KOTPDSIG = -1365442559;
    static final int KOTRDSIG = -1365377023;
    static final int KOTCDSIG = -1365311487;
    static final int KOTODSIG = -1365307391;
    static final int KOTADXSIG = -1365303295;
    static final int KOTADPRV = 1;
    static final int KOTADPUB = 2;
    static final int KOTADCNT = 4;
    static final int KOTADCFM = 248;
    static final int KOTADSUB = 256;
    static final int KOTADPTR = 16384;
    static final int KOTADREF = 32768;
    static final int KOTADCNN = 65536;
    static final int KOTADCFN = 131072;
    static final int KOTADCVN = 262144;
    static final int KOTADTRN = 512;
    static final int KOTADCPT = 4096;
    static final int KOTADIN = 256;
    static final int KOTADOUT = 512;
    static final int KOTADCBR = 1024;
    static final int KOTADREQ = 2048;
    static final int KOTADNCP = 0x100000;
    private int kotadkvn;
    private byte[] kotadnam;
    private byte[] kotadtrf;
    private short kotadtvn;
    private short kotadid;
    private byte[] kotadprf;
    private short kotadpvn;
    private int kotadflg;
    private long kotadpre;
    private int kotadcid;
    private byte kotadscl;
    private int kotadcne;
    private byte[] kotaddft;
    private long kotadtyp;
    private byte[] kotadadd;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    private Kotad() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Kotad unpickleKotad(PickleContext context) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(context));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Kotad kotad = new Kotad();
            context.skipBytes(2);
            long length = context.readLength(true) - 2;
            context.skipBytes(1);
            kotad.kotadkvn = (int)context.readUB4();
            kotad.kotadnam = context.readDataValue();
            kotad.kotadtrf = context.readDataValue();
            context.skipBytes(1);
            kotad.kotadtvn = (short)context.readUB2();
            context.skipBytes(1);
            kotad.kotadid = (short)context.readUB2();
            kotad.kotadprf = context.readDataValue();
            context.skipBytes(1);
            kotad.kotadpvn = (short)context.readUB2();
            context.skipBytes(1);
            kotad.kotadflg = (int)context.readUB4();
            context.skipBytes(1);
            kotad.kotadpre = context.readUB4();
            context.skipBytes(1);
            kotad.kotadcid = context.readUB2();
            context.skipBytes(1);
            kotad.kotadscl = context.readByte();
            context.skipBytes(1);
            kotad.kotadcne = (int)context.readUB4();
            kotad.kotaddft = context.readDataValue();
            context.skipBytes(1);
            kotad.kotadtyp = context.readUB4();
            kotad.kotadadd = context.readDataValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Return: " + kotad);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Kotad kotad2 = kotad;
            return kotad2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final TypeDescriptor unpickleTypeDescriptorImage(PickleContext context) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(context));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Kotad kotad = Kotad.unpickleKotad(context);
            if (kotad.kotadkvn != -1365311487) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(OracleLog.TRACE_20, "         Debug: Kotad.unpickleTypeDescriptorImage: encountered a non-collection type description for what a predefined type.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 179");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 179);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            TypeDescriptor td = Kotad.constructPredefinedTypeDescriptor(kotad);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Return: " + td);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TypeDescriptor typeDescriptor = td;
            return typeDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final AttributeDescriptor unpickleAttributeImage(boolean isPredefined, PickleContext context) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(isPredefined) + ", " + OracleLog.argument(context));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Kotad kotad = Kotad.unpickleKotad(context);
            if (kotad.kotadkvn != -1365573631) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(OracleLog.TRACE_20, "         Debug: Kotad.unpickleAttributeImage: the type isn't an attribute.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 179");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 179);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            TypeDescriptor td = null;
            if (isPredefined) {
                td = Kotad.constructPredefinedTypeDescriptor(kotad);
            }
            AttributeDescriptor ret = new AttributeDescriptor(new String(kotad.kotadnam), kotad.kotadid, kotad.kotadflg, td);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            AttributeDescriptor attributeDescriptor = ret;
            return attributeDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TypeDescriptor constructPredefinedTypeDescriptor(Kotad kotad) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(kotad));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (kotad.kotadtrf.length != 36) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(OracleLog.TRACE_20, "         Debug: kotadtrf is malformed");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 180");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 180);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            for (int i2 = 4; i2 < 18; ++i2) {
                if (kotad.kotadtrf[i2] == 0) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(OracleLog.TRACE_20, "         Debug: this CREF isn't for a predefined type.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 180");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 180);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            short rdbmsTypeCode = TypeDescriptor.OID_TO_TYPECODE[kotad.kotadtrf[19]];
            TypeDescriptor td = new TypeDescriptor(rdbmsTypeCode);
            td.setPrecision(kotad.kotadpre);
            td.setScale(kotad.kotadscl);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Return: " + td);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TypeDescriptor typeDescriptor = td;
            return typeDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.Kotad"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

