/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.converter.CharacterConverterJDBC;

public class CharacterConverter1Byte
extends CharacterConverterJDBC {
    static final long serialVersionUID = 200017349723606452L;
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    public int m_ucsReplacement;
    public int[] m_ucsChar;
    public char[] m_oraCharLevel1;
    public char[] m_oraCharSurrogateLevel;
    public char[] m_oraCharLevel2;
    public byte m_oraCharReplacement;
    protected transient boolean noSurrogate;
    protected transient boolean strictASCII;
    protected transient int m_oraCharLevel2Size;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterConverter1Byte() {
        block12: {
            this.m_ucsReplacement = 0;
            this.m_ucsChar = null;
            this.m_oraCharLevel1 = null;
            this.m_oraCharSurrogateLevel = null;
            this.m_oraCharLevel2 = null;
            this.m_oraCharReplacement = 0;
            this.noSurrogate = true;
            this.strictASCII = true;
            this.m_oraCharLevel2Size = 0;
            this.m_groupId = 0;
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int toUnicode(byte srcChar) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int ucsChar;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((ucsChar = this.m_ucsChar[srcChar & 0xFF]) == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 154);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 154);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ucsChar);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ucsChar;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int toUnicodeWithReplacement(byte srcChar) {
        long __ol_nanos__ = 0L;
        try {
            int ucsChar;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((ucsChar = this.m_ucsChar[srcChar & 0xFF]) == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.m_ucsReplacement);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = this.m_ucsReplacement;
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ucsChar);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = ucsChar;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte toOracleCharacter(char srcChar, char lowSurrogate) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar) + ", " + OracleLog.argument(lowSurrogate));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int l1Key = srcChar >>> 8 & 0xFF;
            int l2Key = srcChar & 0xFF;
            int l3Key = lowSurrogate >>> 8 & 0xFF;
            int l4Key = lowSurrogate & 0xFF;
            if (this.m_oraCharLevel1[l1Key] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] != '\uffff') {
                byte __result__ = (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by = __result__;
                return by;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 155);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 155);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte toOracleCharacter(char srcChar) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int l4Key;
            int l3Key;
            char ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((ret = this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key = srcChar >>> 8] + (l4Key = srcChar & 0xFF)]) != '\uffff') {
                byte __result__ = (byte)ret;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by = __result__;
                return by;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 155);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 155);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte toOracleCharacterWithReplacement(char srcChar, char lowSurrogate) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar) + ", " + OracleLog.argument(lowSurrogate));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int l1Key = srcChar >>> 8 & 0xFF;
            int l2Key = srcChar & 0xFF;
            int l3Key = lowSurrogate >>> 8 & 0xFF;
            int l4Key = lowSurrogate & 0xFF;
            if (this.m_oraCharLevel1[l1Key] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] != '\uffff') {
                byte __result__ = (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by = __result__;
                return by;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.m_oraCharReplacement);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = this.m_oraCharReplacement;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte toOracleCharacterWithReplacement(char srcChar) {
        long __ol_nanos__ = 0L;
        try {
            int l4Key;
            int l3Key;
            char ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((ret = this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key = srcChar >>> 8] + (l4Key = srcChar & 0xFF)]) != '\uffff') {
                byte __result__ = (byte)ret;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by = __result__;
                return by;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.m_oraCharReplacement);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = this.m_oraCharReplacement;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int toUnicodeChars(byte[] srcChar, int offset, char[] dstChar, int dstOffset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(dstChar) + ", " + OracleLog.argument(dstOffset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int endPos = offset + count;
            int ucs2 = 0;
            int dstCharIndex = dstOffset;
            for (i2 = offset; i2 < endPos && dstCharIndex < dstChar.length; ++i2) {
                ucs2 = this.m_ucsChar[srcChar[i2] & 0xFF];
                if (ucs2 == this.m_ucsReplacement) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterConverter1Byte.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 154);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 154);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (((long)ucs2 & 0xFFFFFFFFL) > 65535L) {
                    if (dstCharIndex + 2 < dstChar.length) {
                        --i2;
                        break;
                    }
                    dstChar[dstCharIndex++] = (char)(ucs2 >>> 16);
                    dstChar[dstCharIndex++] = (char)(ucs2 & 0xFFFF);
                    continue;
                }
                dstChar[dstCharIndex++] = (char)ucs2;
            }
            int __result__ = i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toUnicodeString(byte[] srcChar, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int endPos = offset + count;
            StringBuilder ucsChars = new StringBuilder(count);
            int ucs2 = 0;
            for (int i2 = offset; i2 < endPos; ++i2) {
                ucs2 = this.m_ucsChar[srcChar[i2] & 0xFF];
                if (ucs2 == this.m_ucsReplacement) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterConverter1Byte.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 154);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 154);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (((long)ucs2 & 0xFFFFFFFFL) > 65535L) {
                    ucsChars.append((char)(ucs2 >>> 16));
                    ucsChars.append((char)(ucs2 & 0xFFFF));
                    continue;
                }
                ucsChars.append((char)ucs2);
            }
            String __result__ = ucsChars.substring(0, ucsChars.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toUnicodeStringWithReplacement(byte[] srcChar, int offset, int count) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int endPos = offset + count;
            StringBuilder ucsChars = new StringBuilder(count);
            int ucs2 = 0;
            for (int i2 = offset; i2 < endPos; ++i2) {
                ucs2 = this.m_ucsChar[srcChar[i2] & 0xFF];
                if (ucs2 == -1) {
                    ucsChars.append((char)this.m_ucsReplacement);
                    continue;
                }
                ucsChars.append((char)ucs2);
            }
            String __result__ = ucsChars.substring(0, ucsChars.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toOracleString(String srcString) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int srcLength;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcString));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((srcLength = srcString.length()) == 0) {
                byte[] __result__ = new byte[]{};
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = __result__;
                return byArray;
            }
            char[] srcChars = new char[srcLength];
            srcString.getChars(0, srcLength, srcChars, 0);
            byte[] oracleChars = new byte[srcLength * 4];
            int oraCharIdx = 0;
            for (int i2 = 0; i2 < srcLength; ++i2) {
                if (srcChars[i2] >= '\ud800' && srcChars[i2] < '\udc00') {
                    if (i2 + 1 < srcLength && srcChars[i2 + 1] >= '\udc00' && srcChars[i2 + 1] <= '\udfff') {
                        if (this.noSurrogate) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    CharacterConverter1Byte.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 155);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 155);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        oracleChars[oraCharIdx++] = this.toOracleCharacter(srcChars[i2], srcChars[i2 + 1]);
                        ++i2;
                        continue;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterConverter1Byte.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 155);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 155);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                oracleChars[oraCharIdx++] = srcChars[i2] < '\u0080' && this.strictASCII ? (byte)srcChars[i2] : this.toOracleCharacter(srcChars[i2]);
            }
            if (oraCharIdx < oracleChars.length) {
                byte[] returnArray = new byte[oraCharIdx];
                System.arraycopy(oracleChars, 0, returnArray, 0, oraCharIdx);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnArray);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = returnArray;
                return byArray;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleChars);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = oracleChars;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toOracleStringWithReplacement(String srcString) {
        long __ol_nanos__ = 0L;
        try {
            int srcLength;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcString));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((srcLength = srcString.length()) == 0) {
                byte[] __result__ = new byte[]{};
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = __result__;
                return byArray;
            }
            char[] srcChars = new char[srcLength];
            srcString.getChars(0, srcLength, srcChars, 0);
            byte[] oracleChars = new byte[srcLength * 4];
            int oraCharIdx = 0;
            for (int i2 = 0; i2 < srcLength; ++i2) {
                if (srcChars[i2] >= '\ud800' && srcChars[i2] < '\udc00') {
                    if (i2 + 1 < srcLength && srcChars[i2 + 1] >= '\udc00' && srcChars[i2 + 1] <= '\udfff') {
                        oracleChars[oraCharIdx++] = this.noSurrogate ? this.m_oraCharReplacement : this.toOracleCharacterWithReplacement(srcChars[i2], srcChars[i2 + 1]);
                        ++i2;
                        continue;
                    }
                    oracleChars[oraCharIdx++] = this.m_oraCharReplacement;
                    continue;
                }
                oracleChars[oraCharIdx++] = srcChars[i2] < '\u0080' && this.strictASCII ? (byte)srcChars[i2] : this.toOracleCharacterWithReplacement(srcChars[i2]);
            }
            if (oraCharIdx < oracleChars.length) {
                byte[] returnArray = new byte[oraCharIdx];
                System.arraycopy(oracleChars, 0, returnArray, 0, oraCharIdx);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnArray);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = returnArray;
                return byArray;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleChars);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = oracleChars;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildUnicodeToOracleMapping() {
        long __ol_nanos__ = 0L;
        try {
            int l4Key;
            int l3Key;
            int l2Key;
            int l1Key;
            char[] range;
            Object key;
            int ucsCodePt;
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.m_oraCharLevel1 = new char[256];
            this.m_oraCharSurrogateLevel = null;
            this.m_oraCharLevel2 = null;
            Vector<int[]> mapStore = new Vector<int[]>(45055, 12287);
            Hashtable htable = new Hashtable();
            Hashtable htable2 = new Hashtable();
            int mapCount = this.m_ucsChar.length;
            char lev2Freeptr = '\u0000';
            char surLevFreeptr = '\u0000';
            for (i2 = 0; i2 < 256; ++i2) {
                this.m_oraCharLevel1[i2] = 65535;
            }
            for (i2 = 0; i2 < mapCount; ++i2) {
                ucsCodePt = this.m_ucsChar[i2];
                if (ucsCodePt == -1) continue;
                int[] store = new int[]{ucsCodePt, i2};
                mapStore.addElement(store);
                this.storeMappingRange(ucsCodePt, htable, htable2);
            }
            if (this.extraUnicodeToOracleMapping != null) {
                mapCount = this.extraUnicodeToOracleMapping.length;
                for (i2 = 0; i2 < mapCount; ++i2) {
                    ucsCodePt = this.extraUnicodeToOracleMapping[i2][0];
                    this.storeMappingRange(ucsCodePt, htable, htable2);
                }
            }
            Enumeration enumerator = htable.keys();
            int surLevSize = 0;
            int oraCharLevel2Size = 0;
            while (enumerator.hasMoreElements()) {
                key = enumerator.nextElement();
                range = (char[])htable.get(key);
                if (range == null) continue;
                surLevSize += 256;
            }
            enumerator = htable2.keys();
            while (enumerator.hasMoreElements()) {
                key = enumerator.nextElement();
                range = (char[])htable2.get(key);
                if (range == null) continue;
                oraCharLevel2Size += 256;
            }
            if (surLevSize != 0) {
                this.m_oraCharSurrogateLevel = new char[surLevSize];
            }
            if (oraCharLevel2Size != 0) {
                this.m_oraCharLevel2 = new char[oraCharLevel2Size + 256];
            }
            for (i2 = 0; i2 < surLevSize; ++i2) {
                this.m_oraCharSurrogateLevel[i2] = 65535;
            }
            for (i2 = 0; i2 < oraCharLevel2Size + 256; ++i2) {
                this.m_oraCharLevel2[i2] = 65535;
            }
            for (i2 = 0; i2 < mapStore.size(); ++i2) {
                int[] store = (int[])mapStore.elementAt(i2);
                l1Key = store[0] >> 24 & 0xFF;
                l2Key = store[0] >> 16 & 0xFF;
                l3Key = store[0] >> 8 & 0xFF;
                l4Key = store[0] & 0xFF;
                if (l1Key >= 216 && l1Key < 220) {
                    if (this.m_oraCharLevel1[l1Key] == '\uffff') {
                        this.m_oraCharLevel1[l1Key] = surLevFreeptr;
                        surLevFreeptr = (char)(surLevFreeptr + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] = surLevFreeptr;
                        surLevFreeptr = (char)(surLevFreeptr + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] = lev2Freeptr;
                        lev2Freeptr = (char)(lev2Freeptr + 256);
                    }
                    if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] != '\uffff') continue;
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] = (char)(store[1] & 0xFFFF);
                    continue;
                }
                if (this.m_oraCharLevel1[l3Key] == '\uffff') {
                    this.m_oraCharLevel1[l3Key] = lev2Freeptr;
                    lev2Freeptr = (char)(lev2Freeptr + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key] != '\uffff') continue;
                this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key] = (char)(store[1] & 0xFFFF);
            }
            if (this.extraUnicodeToOracleMapping != null) {
                mapCount = this.extraUnicodeToOracleMapping.length;
                for (i2 = 0; i2 < mapCount; ++i2) {
                    ucsCodePt = this.extraUnicodeToOracleMapping[i2][0];
                    l1Key = ucsCodePt >>> 24 & 0xFF;
                    l2Key = ucsCodePt >>> 16 & 0xFF;
                    l3Key = ucsCodePt >>> 8 & 0xFF;
                    l4Key = ucsCodePt & 0xFF;
                    if (l1Key >= 216 && l1Key < 220) {
                        if (this.m_oraCharLevel1[l1Key] == '\uffff') {
                            this.m_oraCharLevel1[l1Key] = surLevFreeptr;
                            surLevFreeptr = (char)(surLevFreeptr + 256);
                        }
                        if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] == '\uffff') {
                            this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] = surLevFreeptr;
                            surLevFreeptr = (char)(surLevFreeptr + 256);
                        }
                        if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] == '\uffff') {
                            this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] = lev2Freeptr;
                            lev2Freeptr = (char)(lev2Freeptr + 256);
                        }
                        this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] = (char)(this.extraUnicodeToOracleMapping[i2][1] & 0xFF);
                        continue;
                    }
                    if (this.m_oraCharLevel1[l3Key] == '\uffff') {
                        this.m_oraCharLevel1[l3Key] = lev2Freeptr;
                        lev2Freeptr = (char)(lev2Freeptr + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key] = (char)(this.extraUnicodeToOracleMapping[i2][1] & 0xFFFF);
                }
            }
            this.noSurrogate = this.m_oraCharSurrogateLevel == null;
            this.strictASCII = true;
            for (i2 = 0; i2 < 128; ++i2) {
                if (this.m_oraCharLevel2[i2] == i2) continue;
                this.strictASCII = false;
                break;
            }
            for (i2 = 0; i2 < 256; ++i2) {
                if (this.m_oraCharLevel1[i2] != '\uffff') continue;
                this.m_oraCharLevel1[i2] = (char)oraCharLevel2Size;
            }
            this.m_oraCharLevel2Size = oraCharLevel2Size;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractCodepoints(Vector vtable) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(vtable));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int begin = 0;
            int end = 255;
            for (int x = begin; x <= end; ++x) {
                try {
                    int[] codepointPair = new int[]{x, this.toUnicode((byte)x)};
                    vtable.addElement(codepointPair);
                    continue;
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractExtraMappings(Vector vtable) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(vtable));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.extraUnicodeToOracleMapping == null) {
                return;
            }
            for (int x = 0; x < this.extraUnicodeToOracleMapping.length; ++x) {
                int[] codepointPair = new int[]{this.extraUnicodeToOracleMapping[x][0], this.extraUnicodeToOracleMapping[x][1]};
                vtable.addElement(codepointPair);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasExtraMappings() {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = this.extraUnicodeToOracleMapping != null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getOraChar1ByteRep() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char __result__ = (char)this.m_oraCharReplacement;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char c2 = __result__;
            return c2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getOraChar2ByteRep() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char c2 = '\u0000';
            return c2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUCS2CharRep() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.m_ucsReplacement);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.m_ucsReplacement;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterConverter1Byte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql.converter");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.converter.CharacterConverter1Byte"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

