/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.i18n.text.converter.CharacterConverter;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.converter.JdbcCharacterConverters;

public class I18CharacterConvertersWrapper
implements JdbcCharacterConverters {
    CharacterConverter wrapper;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public I18CharacterConvertersWrapper(CharacterConverter _wrapper) {
        this.wrapper = _wrapper;
    }

    @Override
    public int getGroupId() {
        return this.wrapper.getGroupId();
    }

    @Override
    public int getOracleId() {
        return this.wrapper.getOracleId();
    }

    @Override
    public char[] getLeadingCodes() {
        return this.wrapper.getLeadingCodes();
    }

    @Override
    public String toUnicodeString(byte[] b2, int i2, int j2) throws SQLException {
        return this.wrapper.toUnicodeString(b2, i2, j2);
    }

    @Override
    public String toUnicodeStringWithReplacement(byte[] b2, int i2, int j2) {
        return this.wrapper.toUnicodeStringWithReplacement(b2, i2, j2);
    }

    @Override
    public byte[] toOracleString(String x) throws SQLException {
        return this.wrapper.toOracleString(x);
    }

    @Override
    public byte[] toOracleStringWithReplacement(String x) {
        return this.wrapper.toOracleStringWithReplacement(x);
    }

    @Override
    public void buildUnicodeToOracleMapping() {
        this.wrapper.buildUnicodeToOracleMapping();
    }

    @Override
    public void extractCodepoints(Vector x) {
        this.wrapper.extractCodepoints(x);
    }

    @Override
    public void extractExtraMappings(Vector x) {
        this.wrapper.extractExtraMappings(x);
    }

    @Override
    public boolean hasExtraMappings() {
        return this.wrapper.hasExtraMappings();
    }

    @Override
    public char getOraChar1ByteRep() {
        return this.wrapper.getOraChar1ByteRep();
    }

    @Override
    public char getOraChar2ByteRep() {
        return this.wrapper.getOraChar2ByteRep();
    }

    @Override
    public int getUCS2CharRep() {
        return this.wrapper.getUCS2CharRep();
    }

    @Override
    public int toUnicodeChars(byte[] srcChar, int offset, char[] dstChar, int dstOffset, int count) throws SQLException {
        return this.wrapper.toUnicodeCharsWithReplacement(srcChar, offset, dstChar, dstOffset, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    I18CharacterConvertersWrapper.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    I18CharacterConvertersWrapper.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    I18CharacterConvertersWrapper.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql.converter");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.converter.I18CharacterConvertersWrapper"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

