/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ConnectionAttributes;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.RfcDestinationMonitor;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.ObjectList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientFactory {
    protected String destinationId;
    protected String originDestinationId;
    protected String destinationName;
    protected ObjectList<ClientConnection> allocated = new ObjectList(10, 10);
    ClientConnection master;
    final Object mutex = new Object();
    RfcDestinationMonitor destMonitor = null;
    private int maxUsed;
    protected long maxGetClientTime = 30000L;
    protected long expirationTime = 0L;
    protected long expirationCheckPeriod = 600000L;
    protected ConnectionAttributes attributes = null;
    boolean repositoryFactory;
    protected long lastActiveTimestamp;
    private int delayedTimeout = 0;

    protected ClientFactory(InternalDestination destination, boolean isRepositoryFactory) {
        this.repositoryFactory = isRepositoryFactory;
        this.setDestinationID(destination);
        this.originDestinationId = destination.getOriginDestinationID(isRepositoryFactory);
        this.destinationName = destination.getDestinationName();
        this.lastActiveTimestamp = System.currentTimeMillis();
    }

    void updateDestination(InternalDestination destination) {
        this.setDestinationID(destination);
    }

    private void setDestinationID(InternalDestination destination) {
        this.destinationId = this.repositoryFactory ? destination.getRepositoryKey() : destination.getDestinationID();
        RfcDestinationMonitor monitor = this.getDestinationMonitor();
        if (monitor != null) {
            monitor.destinationId = this.destinationId;
        }
    }

    protected abstract void init(InternalDestination var1) throws JCoException;

    public final String getName() {
        return this.destinationId;
    }

    protected abstract int getCapacity();

    abstract void setCapacity(int var1);

    public abstract int getPeakLimit();

    abstract void setPeakLimit(int var1);

    public abstract int getCurrentPoolSize();

    public int getPooledConnectionCount() {
        return 0;
    }

    public final int getMaxUsed() {
        return this.maxUsed;
    }

    protected void setMaxUsed(int currUsed) {
        if (this.maxUsed < currUsed) {
            this.maxUsed = currUsed;
        }
    }

    public final int getNumUsed() {
        return this.allocated.size();
    }

    final long getLastActivityTimestamp() {
        return this.lastActiveTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allocate(ClientConnection client) {
        Object object = this.mutex;
        synchronized (object) {
            this.allocated.add(client);
        }
        this.delayedTimeout = 0;
        this.lastActiveTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deallocate(ClientConnection client) {
        Object object = this.mutex;
        synchronized (object) {
            this.allocated.remove(client);
        }
        this.delayedTimeout = 0;
        this.lastActiveTimestamp = System.currentTimeMillis();
    }

    protected String describeAllocatedClients(ObjectList<ClientConnection> allocatedClients) {
        StringBuilder sb = new StringBuilder(250);
        sb.append("Pool ").append(this.getName());
        sb.append(" created ").append(this.getNumUsed()).append(" clients");
        if (allocatedClients.size() > 0) {
            long now = System.currentTimeMillis();
            for (int i = 0; i < allocatedClients.size(); ++i) {
                ClientConnection client = allocatedClients.get(i);
                if (client != null) {
                    byte state = client.getState();
                    long lastUsed = client.last_active_timestamp;
                    long lastCall = client.start_time;
                    sb.append(JCoRuntime.CRLF).append(i + 1).append(") client [");
                    sb.append(client.getConnectionHandle()).append('/').append(client.getConversationID()).append(']');
                    if (lastCall > 0L) {
                        if ((state & 4) != 0) {
                            sb.append(" is calling since ");
                        } else {
                            sb.append(" is idle since ").append(now - lastUsed);
                            sb.append(" ms, since last call ");
                        }
                        sb.append(now - lastCall).append(" ms, function ").append(client.rfm_name);
                    } else {
                        sb.append(" was allocated, but no calls were performed");
                    }
                    if (client.getSessionId() == null) {
                        sb.append(" [stateless]");
                    } else {
                        sb.append(" [stateful session id: ").append(client.getSessionId()).append(']');
                    }
                }
                sb.append(JCoRuntime.CRLF);
            }
        }
        return sb.toString();
    }

    public abstract int getNumWaitingThreads();

    public final void setMaxGetClientTime(long newMaxGetClientTime) {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(100).append("[JCoAPI] ClientFactory.setMaxGetClientTime(").append(newMaxGetClientTime).append(") on pool ").append(this.destinationId).toString());
        }
        if (newMaxGetClientTime >= 0L) {
            this.maxGetClientTime = newMaxGetClientTime;
        }
    }

    public final long getMaxWaitTime() {
        return this.maxGetClientTime;
    }

    public final long getExpirationTime() {
        return this.expirationTime;
    }

    public final void setExpirationTime(long newExpirationTime) {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(100).append("[JCoAPI] ClientFactory.setExpirationTime(").append(newExpirationTime).append(") on pool ").append(this.destinationId).toString());
        }
        this.expirationTime = newExpirationTime;
    }

    public final long getExpirationCheckPeriod() {
        return this.expirationCheckPeriod;
    }

    public void setExpirationCheckPeriod(long newExpirationCheckPeriod) {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(100).append("[JCoAPI] ClientFactory.setExpirationCheckPeriod(").append(newExpirationCheckPeriod).append(") on pool ").append(this.destinationId).toString());
        }
        if (newExpirationCheckPeriod < 0L) {
            throw new IllegalArgumentException(new StringBuilder(100).append("timeout_check_period ").append(newExpirationCheckPeriod).append(" must be greater than or equal to zero.").toString());
        }
        this.expirationCheckPeriod = newExpirationCheckPeriod;
    }

    protected abstract void clear();

    protected abstract ClientConnection getClient() throws JCoException;

    protected abstract void releaseClient(ClientConnection var1) throws JCoException;

    protected boolean isTimedOut(long now) {
        this.delayedTimeout = now > this.lastActiveTimestamp + this.expirationCheckPeriod + this.expirationTime && this.getNumUsed() == 0 ? ++this.delayedTimeout : 0;
        return this.delayedTimeout == 3;
    }

    protected void setAttributes(ConnectionAttributes newAttributes) {
        this.attributes = newAttributes;
    }

    protected ConnectionAttributes getAttributes() {
        return this.attributes;
    }

    protected abstract void detachFromPool(ClientConnection var1) throws JCoException;

    protected abstract void attachToPool(ClientConnection var1, boolean var2) throws JCoException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        Object allocatedCopy;
        Object object = this.mutex;
        synchronized (object) {
            if (this.allocated.isEmpty()) {
                return;
            }
            allocatedCopy = this.allocated.clone();
        }
        ClientConnection conn = (ClientConnection)((ObjectList)allocatedCopy).pop();
        while (conn != null) {
            monitoredData.add(conn.getMonitoredData());
            conn = (ClientConnection)((ObjectList)allocatedCopy).pop();
        }
    }

    RfcDestinationMonitor getDestinationMonitor() {
        return this.destMonitor;
    }

    void setDestinationMonitor(RfcDestinationMonitor monitor) {
        if (this.destMonitor != monitor) {
            if (this.destMonitor != null) {
                this.removeDestinationMonitor();
            }
            this.destMonitor = monitor;
        }
    }

    void removeDestinationMonitor() {
        RfcDestinationMonitor monitor = this.destMonitor;
        if (monitor != null) {
            monitor.removeClientFactory(this);
            this.destMonitor = null;
        }
    }

    final String getDestinationID() {
        return this.destinationId;
    }

    final String getOriginDestinationID() {
        return this.originDestinationId;
    }

    final String getDestinationName() {
        return this.destinationName;
    }
}

