/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoTraceListener;
import com.sap.conn.jco.ext.DefaultSessionReferenceProvider;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.monitor.JCoServerMonitor;
import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.ConnectionMonitor;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultConnectionManager;
import com.sap.conn.jco.rt.DefaultDestinationManager;
import com.sap.conn.jco.rt.DefaultServerManager;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.MiddlewareJavaRfc;
import com.sap.conn.jco.rt.PropertyFileDestinationDataProvider;
import com.sap.conn.jco.rt.PropertyFileServerDataProvider;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.SessionFinalizer;
import com.sap.conn.jco.rt.SessionTimeoutChecker;
import com.sap.conn.jco.rt.StandaloneServerFactory;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.DefaultSharedStorage;
import com.sap.conn.jco.util.DefaultTrace;
import com.sap.conn.jco.util.SapLoggingTrace;
import com.sap.conn.jco.util.SharedStorage;
import com.sap.conn.rfc.api.RfcRuntime;
import com.sap.conn.rfc.engine.DefaultRfcRuntime;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Security;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultJCoRuntime
extends JCoRuntime {
    static final String PROPERTY_DESTINATION_DIRECTORY = "jco.destinations.dir";
    private static final String JCO_LIB_BASENAME = "sapjco3";
    private static final String JCO_SA_JARNAME = "sapjco3.jar";
    private static final String JCO_IDE_JARNAME = "sapjco3_IDE.jar";
    private static final String JCO_OSGI_BASENAME = "com.sap.conn.jco";
    private static Hashtable<String, Object> globalStorage = new Hashtable();
    private static boolean initializedJniLib = false;
    private Map<String, Context> contexts = null;
    private RfcRuntime rfcRuntimeInstance = null;
    private ConnectionMonitor connectionMonitor = null;
    private DefaultDestinationManager destinationManager = null;
    private StandaloneServerFactory serverFactory = null;
    private DefaultServerManager serverManager = null;
    private SessionTimeoutChecker sessionTimeoutChecker = null;
    private AutoJobRunner autoJobRunner = null;
    private DefaultTrace jcoTrace = null;

    DefaultJCoRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        Hashtable<String, Object> hashtable = globalStorage;
        synchronized (hashtable) {
            this.contexts = (Map)globalStorage.get("Contexts");
            if (this.contexts == null) {
                this.contexts = new Hashtable<String, Context>();
                globalStorage.put("Contexts", this.contexts);
            }
        }
        this.destinationManager = this.createDestinationManager();
        this.rfcRuntimeInstance = new DefaultRfcRuntime();
        this.middlewareInstance = new MiddlewareJavaRfc();
        this.createConnectionManager();
        this.connectionMonitor = new ConnectionMonitor();
        this.serverManager = new DefaultServerManager();
        this.serverFactory = this.createServerFactory();
        this.sessionRefProvider = new DefaultSessionReferenceProvider();
        RuntimeEnvironment.setDefaultSessionReferenceProvider(this.sessionRefProvider);
        this.sessionTimeoutChecker = new SessionTimeoutChecker(this.contexts, true);
        this.startAutoJob(this.sessionTimeoutChecker);
        this.setMiddlewarePropertyValue("jco.middleware.native_layer_path", JCoRuntime.nativeLibraryPath);
        if (Environment.inEclipsePlugin()) {
            SapLoggingTrace.initialize();
        }
    }

    @Override
    protected void readSystemProperties() {
        block14: {
            super.readSystemProperties();
            try {
                this.setSystemProperty("jco.allow_non_abap_partner", "0");
                this.setSystemProperty("jco.cpic_maxconv", "202");
                this.setSystemProperty("jco.program_name", "SAPJCo30");
                int defaultTTL = 86400;
                int defaultNegativeTTL = 10;
                String ttlString = null;
                try {
                    ttlString = Security.getProperty("networkaddress.cache.ttl");
                }
                catch (RuntimeException re) {
                    Trace.fireTrace(128, "[JCoAPI] Exception occurred while retrieving the Java security property networkaddress.cache.ttl:", re);
                }
                if (ttlString != null && ttlString.length() > 0) {
                    try {
                        defaultTTL = Integer.parseInt(ttlString);
                        if (defaultTTL < 0 || defaultTTL > 86400) {
                            defaultTTL = 86400;
                        }
                    }
                    catch (RuntimeException re) {
                        Trace.fireTrace(128, "[JCoAPI] Default value \"" + ttlString + "\" for property " + "jco.ni.dnscache.ttl" + " is not an integer");
                    }
                }
                try {
                    ttlString = null;
                    ttlString = Security.getProperty("networkaddress.cache.negative.ttl");
                }
                catch (RuntimeException re) {
                    Trace.fireTrace(128, "[JCoAPI] Exception occurred while retrieving the Java security property networkaddress.cache.negative.ttl:", re);
                }
                if (ttlString != null && ttlString.length() > 0) {
                    try {
                        defaultNegativeTTL = Integer.parseInt(ttlString);
                        if (defaultNegativeTTL < 0 || defaultNegativeTTL > 86400) {
                            defaultNegativeTTL = 86400;
                        }
                    }
                    catch (RuntimeException re) {
                        Trace.fireTrace(128, "[JCoAPI] Default value \"" + ttlString + "\" for property " + "jco.ni.dnscache.negative.ttl" + " is not an integer");
                    }
                }
                this.setSystemProperty("jco.ni.dnscache.ttl", Integer.toString(defaultTTL));
                this.setSystemProperty("jco.ni.dnscache.negative.ttl", Integer.toString(defaultNegativeTTL));
            }
            catch (RuntimeException re) {
                if (!JCoRuntime.nativeLibraryLoadFailure) break block14;
                Trace.fireTraceCritical("[JCoAPI] Exception while reading system properties:", re);
            }
        }
    }

    @Override
    protected JCoMiddleware getMiddlewareInstance() {
        return this.middlewareInstance;
    }

    @Override
    protected void updateDestinationDataProvider(DestinationDataProvider provider) {
        this.destinationManager.updateDestinationDataProvider(provider);
    }

    @Override
    protected void updateServerDataProvider(ServerDataProvider provider) {
        this.serverFactory.updateServerDataProvider(provider);
    }

    StandaloneServerFactory createServerFactory() {
        ServerDataProvider provider = RuntimeEnvironment.getServerDataProvider();
        try {
            String directory = System.getProperty(PROPERTY_DESTINATION_DIRECTORY, ".");
            if (provider == null) {
                provider = new PropertyFileServerDataProvider(directory);
            }
        }
        catch (FileNotFoundException e) {
            throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", e.toString());
        }
        return new StandaloneServerFactory(provider, this.serverManager);
    }

    void adjustServerFactory(StandaloneServerFactory serverFactory) {
        this.serverFactory = serverFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void updateSessionRefProvider(SessionReferenceProvider provider) {
        if (provider != this.sessionRefProvider) {
            Hashtable<String, Object> hashtable = globalStorage;
            synchronized (hashtable) {
                if (this.contexts.size() > 0) {
                    this.startAutoJob(new SessionFinalizer(this.autoJobRunner, this.contexts));
                    this.contexts = new Hashtable<String, Context>();
                    globalStorage.put("Contexts", this.contexts);
                }
                this.sessionTimeoutChecker.reset(this.contexts, true);
            }
        }
        this.sessionRefProvider = provider;
        if (this.sessionRefProvider == null) {
            this.sessionRefProvider = RuntimeEnvironment.getSessionReferenceProvider();
        }
    }

    @Override
    protected Context getRuntimeContext(String scopeType) {
        Context ctx = null;
        JCoSessionReference sessionRef = this.sessionRefProvider.getCurrentSessionReference(scopeType);
        if (sessionRef != null) {
            ctx = this.contexts.get(sessionRef.getID());
            if (ctx != null) {
                ctx.setSessionReference(sessionRef, scopeType);
            } else {
                ctx = new Context();
                ctx.setSessionReference(sessionRef, scopeType);
                this.contexts.put(sessionRef.getID(), ctx);
            }
        } else {
            String msg = new StringBuilder(160).append("Session reference is null. SessionReferenceProvider: ").append(this.sessionRefProvider.getClass().getName()).append(", scope type: ").append(scopeType).toString();
            Trace.fireTraceCritical(new StringBuilder(msg.length() + 9).append("[JCoAPI] ").append(msg).toString(), true);
            throw new JCoRuntimeException(153, "JCO_ERROR_SESSION_REF_NOT_VALID", msg);
        }
        ctx.setLastAccess(System.currentTimeMillis());
        return ctx;
    }

    @Override
    protected Context getRuntimeContext(String sessionId, boolean create) {
        Context ctx = this.contexts.get(sessionId);
        if (ctx == null) {
            if (create) {
                ctx = new Context();
                ctx.setSessionID(sessionId);
                this.contexts.put(sessionId, ctx);
            }
        } else {
            ctx.setLastAccess(System.currentTimeMillis());
        }
        return ctx;
    }

    @Override
    protected void releaseRuntimeContext(Context ctx) {
        Context removed = null;
        if (ctx == null) {
            String sessionID;
            JCoSessionReference sessionRef = this.sessionRefProvider.getCurrentSessionReference(null);
            if (sessionRef != null && (sessionID = sessionRef.getID()) != null) {
                removed = this.contexts.remove(sessionID);
            }
        } else {
            String sessionID = ctx.getSessionID();
            if (sessionID != null) {
                removed = this.contexts.remove(sessionID);
            }
            if (ctx != removed) {
                ctx.removeSessionReference();
                ctx.reset();
            }
        }
        if (removed != null) {
            removed.removeSessionReference();
            removed.reset();
        }
    }

    @Override
    protected DefaultDestinationManager getDestinationManager() {
        return this.destinationManager;
    }

    private DefaultDestinationManager createDestinationManager() {
        try {
            String directory = System.getProperty(PROPERTY_DESTINATION_DIRECTORY, ".");
            PropertyFileDestinationDataProvider defProvider = new PropertyFileDestinationDataProvider(directory);
            RuntimeEnvironment.setDefaultDestinationDataProvider(defProvider);
        }
        catch (FileNotFoundException e) {
            throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", e.toString());
        }
        DestinationDataProvider provider = RuntimeEnvironment.getDestinationDataProvider();
        return new DefaultDestinationManager(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <V extends Serializable> SharedStorage<String, V> createSharedStorage(String name) {
        DefaultSharedStorage storage = (DefaultSharedStorage)globalStorage.get(name);
        if (storage == null) {
            Hashtable<String, Object> hashtable = globalStorage;
            synchronized (hashtable) {
                storage = (DefaultSharedStorage)globalStorage.get(name);
                if (storage == null) {
                    storage = new DefaultSharedStorage(name);
                    globalStorage.put(name, storage);
                }
            }
        }
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <V extends Serializable> boolean removeSharedStorage(SharedStorage<String, V> sharedStorage) {
        boolean removed = false;
        if (sharedStorage != null) {
            Hashtable<String, Object> hashtable = globalStorage;
            synchronized (hashtable) {
                removed = globalStorage.remove(sharedStorage.getName()) != null;
            }
        }
        return removed;
    }

    @Override
    protected ConnectionManager createConnectionManager() {
        return new DefaultConnectionManager();
    }

    @Override
    protected String getRuntimeParameter(String parameter) {
        return System.getProperty(parameter);
    }

    @Override
    protected boolean registerNativeMethods(Class<?> clazz) {
        if (!initializedJniLib) {
            try {
                JCoRuntime.nativeLibraryPath = DefaultJCoRuntime.loadJCoLibrary();
                initializedJniLib = true;
            }
            catch (UnsatisfiedLinkError ule) {
                JCoRuntime.nativeLibraryPath = "not loaded, caused by " + ule.toString();
                ule.printStackTrace();
                throw ule;
            }
        }
        return true;
    }

    private static String loadJCoLibrary() {
        String myUrlProtocol;
        String myResourceName;
        URL myUrl;
        block88: {
            myUrl = null;
            myResourceName = null;
            myUrlProtocol = null;
            try {
                Class<?> classURLResolver;
                Class<DefaultJCoRuntime> myClass = DefaultJCoRuntime.class;
                myResourceName = myClass.getName().replace('.', '/') + ".class";
                myUrl = myClass.getClassLoader().getResource(myResourceName);
                myUrlProtocol = myUrl.getProtocol();
                if (!"bundleresource".equals(myUrlProtocol)) break block88;
                try {
                    classURLResolver = myClass.getClassLoader().loadClass("org.eclipse.core.runtime.FileLocator");
                }
                catch (Throwable t) {
                    classURLResolver = myClass.getClassLoader().loadClass("org.eclipse.core.runtime.Platform");
                }
                Method methodResolve = classURLResolver.getDeclaredMethod("resolve", URL.class);
                myUrl = (URL)methodResolve.invoke(classURLResolver, myUrl);
                myUrlProtocol = myUrl.getProtocol();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if ("bundleresource".equals(myUrlProtocol)) {
            try {
                System.loadLibrary(JCO_LIB_BASENAME);
                String fullname = System.mapLibraryName(JCO_LIB_BASENAME);
                return new StringBuilder(23 + fullname.length()).append("System-defined path to ").append(fullname).toString();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        OS os = OS.unknown;
        String libname = null;
        try {
            String osName = System.getProperty("os.name", "").toLowerCase(Locale.US);
            if (osName.startsWith("windows")) {
                os = OS.Windows;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 4).append(JCO_LIB_BASENAME).append(".dll").toString();
            } else if (osName.startsWith("linux")) {
                os = OS.Linux;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else if (osName.startsWith("mac")) {
                os = OS.MacOS;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 10).append("lib").append(JCO_LIB_BASENAME).append(".jnilib").toString();
            } else if (osName.startsWith("aix")) {
                os = OS.AIX;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else if (osName.startsWith("hp-ux")) {
                if (System.getProperty("os.arch", "").toLowerCase(Locale.US).startsWith("pa")) {
                    os = OS.HPUX_PARISC;
                    libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".sl").toString();
                } else {
                    os = OS.HPUX_IA64;
                    libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
                }
            } else if (osName.startsWith("sunos")) {
                os = OS.SunOS;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else if (osName.startsWith("z/os")) {
                os = OS.zOS;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else if (osName.equals("os400") || osName.equals("os/400")) {
                os = OS.OS400;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else {
                os = OS.unknown;
                libname = System.mapLibraryName(JCO_LIB_BASENAME);
            }
        }
        catch (Throwable t) {
            os = OS.unknown;
            libname = System.mapLibraryName(JCO_LIB_BASENAME);
        }
        int strLen = 0;
        String path = null;
        File file = null;
        if ("jar".equals(myUrlProtocol) || "file".equals(myUrlProtocol)) {
            try {
                path = URLDecoder.decode(myUrl.getFile(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            if (path == null) {
                path = myUrl.getFile();
            }
            if ((path = path.substring(0, path.length() - myResourceName.length())).startsWith("jar:")) {
                path = path.substring(4);
            }
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if ("jar".equals(myUrlProtocol)) {
                int startIndex;
                String jarname = null;
                int endIndex = path.lastIndexOf(33);
                if (endIndex < 0) {
                    endIndex = path.length();
                }
                if ((startIndex = path.lastIndexOf(47, endIndex)) >= 0) {
                    jarname = path.substring(startIndex + 1, endIndex);
                    path = path.substring(0, startIndex + 1);
                } else {
                    jarname = path;
                    path = "";
                }
                if (!(jarname.equals(JCO_SA_JARNAME) || jarname.startsWith(JCO_OSGI_BASENAME) || jarname.equals(JCO_IDE_JARNAME) || Package.getPackage("org.apache.maven.surefire.booter") != null || Package.getPackage("org.eclipse.jdt.internal.junit.runner") != null)) {
                    throw new ExceptionInInitializerError("Illegal JCo archive \"" + jarname + "\". It is not allowed to rename or repackage the original archive \"" + JCO_SA_JARNAME + "\".");
                }
            }
            try {
                strLen = path.length() + libname.length();
                file = new File(new StringBuilder(strLen).append(path).append(libname).toString());
                if (file.isFile() && file.canRead()) {
                    path = file.getCanonicalPath();
                    System.load(path);
                    return path;
                }
            }
            catch (UnsatisfiedLinkError ule) {
                if (os == OS.OS400) {
                    try {
                        return DefaultJCoRuntime.loadOS400JCoLibraries(path, path.length() - libname.length());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw ule;
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                switch (os) {
                    case Windows: {
                        String osArch = System.getProperty("os.arch", "").toLowerCase(Locale.US);
                        if (osArch.equals("amd64") || osArch.length() == 0) {
                            path = new StringBuilder(strLen + 8).append(path).append("ntamd64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("x86")) {
                            path = new StringBuilder(strLen + 8).append(path).append("ntintel/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("ia64")) {
                            path = new StringBuilder(strLen + 7).append(path).append("ntia64/").append(libname).toString();
                            break;
                        }
                        path = new StringBuilder(strLen + 8).append(path).append("ntamd64/").append(libname).toString();
                        break;
                    }
                    case Linux: {
                        String osArch = System.getProperty("os.arch", "").toLowerCase(Locale.US);
                        if (osArch.equals("amd64") || osArch.length() == 0) {
                            path = new StringBuilder(strLen + 12).append(path).append("linuxx86_64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("i386") || osArch.equals("x86")) {
                            path = new StringBuilder(strLen + 11).append(path).append("linuxintel/").append(libname).toString();
                            break;
                        }
                        if (osArch.charAt(0) == 'p') {
                            int idx = osArch.length();
                            if (idx > 2 && osArch.charAt(--idx) == 'e' && osArch.charAt(--idx) == 'l') {
                                path = new StringBuilder(strLen + 13).append(path).append("linuxppc64le/").append(libname).toString();
                                break;
                            }
                            path = new StringBuilder(strLen + 11).append(path).append("linuxppc64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("ia64")) {
                            path = new StringBuilder(strLen + 10).append(path).append("linuxia64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("zarch_64") || osArch.equals("s390x")) {
                            path = new StringBuilder(strLen + 11).append(path).append("linuxs390x/").append(libname).toString();
                            break;
                        }
                        path = new StringBuilder(strLen + 12).append(path).append("linuxx86_64/").append(libname).toString();
                        break;
                    }
                    case MacOS: {
                        String osArch = System.getProperty("os.arch", "").toLowerCase(Locale.US);
                        if (osArch.equals("x86_64") || osArch.length() == 0) {
                            path = new StringBuilder(strLen + 14).append(path).append("darwinintel64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("i386") || osArch.equals("x86")) {
                            path = new StringBuilder(strLen + 12).append(path).append("darwinintel/").append(libname).toString();
                            break;
                        }
                        if (osArch.charAt(0) == 'p') {
                            path = null;
                            break;
                        }
                        path = new StringBuilder(strLen + 14).append(path).append("darwinintel64/").append(libname).toString();
                        break;
                    }
                    case AIX: {
                        path = new StringBuilder(strLen + 10).append(path).append("rs6000_64/").append(libname).toString();
                        break;
                    }
                    case HPUX_IA64: {
                        path = new StringBuilder(strLen + 7).append(path).append("hpia64/").append(libname).toString();
                        break;
                    }
                    case HPUX_PARISC: {
                        path = new StringBuilder(strLen + 6).append(path).append("hp_64/").append(libname).toString();
                        break;
                    }
                    case SunOS: {
                        String osArch = System.getProperty("os.arch", "").toLowerCase(Locale.US);
                        if (osArch.equals("amd64") || osArch.length() == 0) {
                            path = new StringBuilder(strLen + 10).append(path).append("sunx86_64/").append(libname).toString();
                            break;
                        }
                        if (osArch.charAt(0) == 's') {
                            path = new StringBuilder(strLen + 7).append(path).append("sun_64/").append(libname).toString();
                            break;
                        }
                        if (osArch.charAt(0) == 'p') {
                            path = null;
                            break;
                        }
                        path = new StringBuilder(strLen + 10).append(path).append("sunx86_64/").append(libname).toString();
                        break;
                    }
                    case zOS: {
                        path = new StringBuilder(strLen + 9).append(path).append("os390_64/").append(libname).toString();
                        break;
                    }
                    case OS400: {
                        path = new StringBuilder(strLen + 14).append(path).append("as400_pase_64/").append(libname).toString();
                        break;
                    }
                    default: {
                        path = null;
                    }
                }
                if (path != null && (file = new File(path)).isFile() && file.canRead()) {
                    path = file.getCanonicalPath();
                    System.load(path);
                    return path;
                }
            }
            catch (UnsatisfiedLinkError ule) {
                if (os == OS.OS400) {
                    try {
                        return DefaultJCoRuntime.loadOS400JCoLibraries(path, path.length() - libname.length());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw ule;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            strLen = libname.length() + 1;
            path = System.getProperty("java.library.path", "");
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                try {
                    path = tokenizer.nextToken();
                    if (path == null || path.length() == 0 || !(file = new File(new StringBuilder(path.length() + strLen).append(path).append(File.separatorChar).append(libname).toString())).isFile() || !file.canRead()) continue;
                    path = file.getCanonicalPath();
                    System.load(path);
                    return path;
                }
                catch (UnsatisfiedLinkError ule) {
                    if (os == OS.OS400) {
                        try {
                            return DefaultJCoRuntime.loadOS400JCoLibraries(path, path.length() - libname.length());
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw ule;
                }
                catch (Throwable t) {
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        System.loadLibrary(JCO_LIB_BASENAME);
        return new StringBuilder(23 + libname.length()).append("System-defined path to ").append(libname).toString();
    }

    private static String loadOS400JCoLibraries(String path, int dirLen) {
        System.load(new StringBuilder(dirLen + 13).append(path.substring(0, dirLen)).append("libpathextension.so").toString());
        System.load(path);
        return path;
    }

    @Override
    public RfcRuntime getRfcRuntimeInstance() {
        return this.rfcRuntimeInstance;
    }

    @Override
    protected DefaultServerManager getJCoServerFactoryInstance() {
        return this.serverManager;
    }

    @Override
    protected void addTraceListener(JCoTraceListener listener) {
        super.addTraceListener(listener);
        if (this.jcoTrace != null && this.jcoTrace.isStandardOutputOn()) {
            Trace.removeTraceListener(this.jcoTrace);
            this.jcoTrace = null;
        }
    }

    @Override
    protected void removeTraceListener(JCoTraceListener listener) {
        super.removeTraceListener(listener);
    }

    @Override
    protected void setRuntimeTrace(int level, String path) {
        super.setRuntimeTrace(level, path);
        if (level == 0) {
            if (this.jcoTrace != null) {
                Trace.removeTraceListener(this.jcoTrace);
                this.jcoTrace = null;
            }
        } else if (this.jcoTrace == null) {
            if (Trace.getTraceListenerCount() == 0) {
                this.jcoTrace = (DefaultTrace)DefaultTrace.getListener();
                Trace.addTracelistener(this.jcoTrace);
                this.jcoTrace.setTracePath(path);
            }
        } else {
            this.jcoTrace.setTracePath(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean startAutoJob(AutoJobRunner.AutoJob job) {
        DefaultJCoRuntime defaultJCoRuntime = this;
        synchronized (defaultJCoRuntime) {
            if (this.autoJobRunner == null) {
                this.autoJobRunner = new AutoJobRunner();
                this.autoJobRunner.initialize();
            }
        }
        return this.autoJobRunner.addJob(job);
    }

    @Override
    public void endTask() {
    }

    @Override
    public void startTask(String monitorEntry) {
    }

    StandaloneServerFactory getServerFactory() {
        return this.serverFactory;
    }

    @Override
    protected List<String> getServerIDs() {
        return this.getJCoServerFactoryInstance().getServerIDs();
    }

    @Override
    protected JCoServerMonitor getServerMonitor(String serverID) {
        return this.getJCoServerFactoryInstance().getServerMonitor(serverID);
    }

    @Override
    protected ConnectionMonitor getConnectionMonitor() {
        return this.connectionMonitor;
    }

    @Override
    protected void setPropertyValue(String key, String value) {
        super.setPropertyValue(key, value);
        if ("jco.session_timeout".equals(key) || "jco.session_timeout.check_interval".equals(key)) {
            this.autoJobRunner.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OS {
        unknown,
        Windows,
        Linux,
        MacOS,
        AIX,
        HPUX_IA64,
        HPUX_PARISC,
        SunOS,
        zOS,
        OS400;

    }
}

