/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.RepositoryConnection;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.LimitedList;
import com.sap.conn.jco.util.ObjectList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolingFactory
extends ClientFactory {
    private int peakLimit;
    private int capacity;
    protected long nextExpirationCheck;
    private LimitedList<ClientConnection> available;
    private ObjectList<Thread> waitingThreads = null;
    private boolean isInitialized = false;

    protected PoolingFactory(InternalDestination destination, boolean repositoryFactory) {
        super(destination, repositoryFactory);
        this.setDestinationProperties(destination);
    }

    private void setDestinationProperties(JCoDestination destination) {
        this.master = this.repositoryFactory ? new RepositoryConnection(destination) : new ClientConnection(destination);
        this.master.pool = this;
        this.expirationCheckPeriod = destination.getExpirationCheckPeriod();
        this.expirationTime = destination.getExpirationTime();
        this.maxGetClientTime = destination.getMaxGetClientTime();
        this.capacity = destination.getPoolCapacity();
        this.setPeakLimit(destination.getPeakLimit());
        if (this.expirationTime == 0L) {
            this.setCapacity(0);
        } else {
            this.setCapacity(this.capacity);
        }
        if (this.capacity == 0 && this.expirationTime != 0L) {
            this.setExpirationTime(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void updateDestination(InternalDestination destination) {
        Object object = this.mutex;
        synchronized (object) {
            super.updateDestination(destination);
            this.setDestinationProperties(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init(InternalDestination destination) throws JCoException {
        if (this.isInitialized) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            boolean toExtern;
            if (this.isInitialized) {
                return;
            }
            this.master.connect();
            char destType = destination.getType();
            boolean bl = toExtern = destType == 'R' || destType == 'E';
            if (toExtern) {
                try {
                    this.master.ping();
                    boolean reinit = false;
                    String pcsProp = this.master.properties.getProperty("jco.client.pcs");
                    String partnerCP = this.master.getAttributes().getPartnerCodepage();
                    if (partnerCP != null && partnerCP.length() == 4 && partnerCP.charAt(0) == '4' && partnerCP.charAt(1) == '1' && partnerCP.charAt(2) == '0') {
                        boolean bl2 = reinit = this.master.properties.remove("jco.client.codepage") != null;
                        if (pcsProp == null || !pcsProp.equals("2")) {
                            this.master.properties.put("jco.client.pcs", "2");
                            reinit = true;
                        }
                    } else {
                        if (partnerCP != null && !partnerCP.equals(this.master.properties.getProperty("jco.client.codepage"))) {
                            this.master.properties.put("jco.client.codepage", partnerCP);
                            reinit = true;
                        }
                        if (pcsProp != null && !pcsProp.equals("1")) {
                            this.master.properties.remove("jco.client.pcs");
                            reinit = true;
                        }
                    }
                    if (reinit) {
                        this.master.middleware.initialize(this.master.properties);
                    }
                }
                catch (JCoException ex) {
                    String cpProp = this.master.properties.getProperty("jco.client.codepage");
                    String pcsProp = this.master.properties.getProperty("jco.client.pcs");
                    if (ex.getGroup() == 104 && (!"2".equals(pcsProp) || cpProp != null && "2".equals(pcsProp))) {
                        if (cpProp != null) {
                            this.master.properties.remove("jco.client.codepage");
                        }
                        if (!"2".equals(pcsProp)) {
                            this.master.properties.put("jco.client.pcs", "2");
                        }
                        this.master.middleware.initialize(this.master.properties);
                        this.master.connect();
                        try {
                            this.master.ping();
                        }
                        catch (JCoException ex2) {
                            if (cpProp != null) {
                                this.master.properties.put("jco.client.codepage", cpProp);
                            }
                            if (pcsProp == null) {
                                this.master.properties.remove("jco.client.pcs");
                            } else if (!"2".equals(pcsProp)) {
                                this.master.properties.put("jco.client.pcs", pcsProp);
                            }
                            throw ex;
                        }
                    }
                    throw ex;
                }
            }
            this.setAttributes(this.master.getAttributes());
            this.attributes.attributesProvider = destination;
            if (this.available.getLimit() > 0 && !toExtern) {
                this.available.push(this.master.hide());
            } else {
                this.master.disconnect(true);
            }
            if (JCoRuntime.properties.getProperty("jco.client.idle_timeout", null) != null) {
                int idle_timeout = Integer.parseInt(JCoRuntime.properties.getProperty("jco.client.idle_timeout")) * 1000;
                if (this.getExpirationTime() > (long)idle_timeout) {
                    this.setExpirationTime(idle_timeout);
                }
            }
            this.isInitialized = true;
        }
        this.lastActiveTimestamp = System.currentTimeMillis();
    }

    @Override
    public final int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void setCapacity(int newCapacity) {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(100).append("[JCoAPI] PoolingFactory.setCapacity(").append(newCapacity).append(") on pool ").append(this.destinationId).toString());
        }
        if (newCapacity < 0) {
            throw new IllegalArgumentException(new StringBuilder(100).append("capacity ").append(newCapacity).append(" is less than zero").toString());
        }
        Object object = this.mutex;
        synchronized (object) {
            int availableSize;
            int n = availableSize = this.available == null ? 0 : this.available.size();
            if (newCapacity < availableSize) {
                int to = availableSize - newCapacity;
                for (int i = 0; i < to; ++i) {
                    ClientConnection to_close = this.available.remove(0);
                    try {
                        to_close.disconnect(true);
                        continue;
                    }
                    catch (JCoException je) {
                        // empty catch block
                    }
                }
            }
            if (this.available == null) {
                this.available = new LimitedList(newCapacity);
            } else {
                this.available.setLimit(newCapacity);
            }
        }
        this.capacity = newCapacity;
        if (this.capacity > this.peakLimit) {
            this.setPeakLimit(this.capacity);
        }
    }

    @Override
    public final int getPeakLimit() {
        return this.peakLimit;
    }

    @Override
    final void setPeakLimit(int newPeakLimit) {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(100).append("[JCoAPI] PoolingFactory.setPeakLimit(").append(newPeakLimit).append(") on pool ").append(this.destinationId).toString());
        }
        this.peakLimit = newPeakLimit;
        if (this.peakLimit < this.capacity) {
            this.setCapacity(this.peakLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getCurrentPoolSize() {
        Object object = this.mutex;
        synchronized (object) {
            return this.getNumUsed() + this.available.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getPooledConnectionCount() {
        Object object = this.mutex;
        synchronized (object) {
            return this.available.size();
        }
    }

    @Override
    public final int getNumWaitingThreads() {
        return this.waitingThreads != null ? this.waitingThreads.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void clear() {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(100).append("[JCoAPI] PoolingFactory.clear() on pool ").append(this.destinationId).toString());
        }
        Object object = this.mutex;
        synchronized (object) {
            while (!this.available.isEmpty()) {
                try {
                    this.available.pop().disconnect(true);
                }
                catch (JCoException jCoException) {}
            }
            this.lastActiveTimestamp = System.currentTimeMillis();
            if (this.waitingThreads != null && this.waitingThreads.size() > 0) {
                if (Trace.isOn(2)) {
                    Trace.fireTrace(2, new StringBuilder(120).append("[JCoAPI] Warning: PoolingFactory.clear() was called although ").append(this.waitingThreads.size()).append(" threads are still waiting in getClient()").toString());
                }
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected ClientConnection getClient() throws JCoException {
        ClientConnection client = null;
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(100).append("[JCoAPI] PoolingFactory.getClient() on pool ").append(this.destinationId).toString());
        }
        Object object = this.mutex;
        synchronized (object) {
            block32: {
                if (this.capacity > 0 && !this.available.isEmpty()) {
                    client = this.available.pop();
                    this.allocate(client);
                } else if (this.getNumUsed() < this.peakLimit) {
                    client = this.master.clone();
                    client.pool = this;
                    this.allocate(client);
                } else if (this.maxGetClientTime > 0L) {
                    if (Trace.isOn(4)) {
                        Trace.fireTrace(4, new StringBuilder(140).append("[JCoAPI] PoolingFactory.getClient(): No connection available [pool size: ").append(this.getCurrentPoolSize()).append(", peak limit: ").append(this.getPeakLimit()).append(", waiting threads: ").append(this.getNumWaitingThreads()).append(", currently used: ").append(this.getNumUsed()).append(']').toString());
                    }
                    long duration = this.maxGetClientTime;
                    Thread currentThread = Thread.currentThread();
                    try {
                        if (this.waitingThreads == null) {
                            this.waitingThreads = new ObjectList();
                        }
                        this.waitingThreads.add(currentThread);
                        while (client == null && duration > 0L) {
                            long t0 = System.currentTimeMillis();
                            this.mutex.wait(duration);
                            int num_available = Math.min(this.capacity - this.getNumUsed(), this.waitingThreads.size());
                            for (int i = 0; i < num_available; ++i) {
                                if (this.waitingThreads.get(i) != currentThread) continue;
                                if (this.capacity > 0 && !this.available.isEmpty()) {
                                    client = this.available.pop();
                                    this.allocate(client);
                                    break;
                                }
                                if (this.getNumUsed() >= this.peakLimit) break;
                                client = this.master.clone();
                                client.pool = this;
                                this.allocate(client);
                                break;
                            }
                            duration -= System.currentTimeMillis() - t0;
                        }
                        Object var11_12 = null;
                        this.waitingThreads.remove(currentThread);
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        this.waitingThreads.remove(currentThread);
                        if (this.waitingThreads.size() == 0) {
                            this.waitingThreads = null;
                        }
                        throw throwable;
                    }
                    if (this.waitingThreads.size() == 0) {
                        this.waitingThreads = null;
                    }
                    break block32;
                    {
                        catch (InterruptedException ex) {
                            if (Trace.isOn(2)) {
                                Trace.fireTrace(2, new StringBuilder(100).append("[JCoAPI] PoolingFactory.getClient(): wait(").append(duration).append(") caused ").append(ex.toString()).toString());
                            }
                            throw new JCoException(106, "JCO_ERROR_RESOURCE", ex.toString(), ex);
                        }
                    }
                }
            }
            if (client == null) {
                this.lastActiveTimestamp = System.currentTimeMillis();
                String msg = new StringBuilder(250).append("Connection pool ").append(this.destinationId).append(" is exhausted. The current pool size peak limit is ").append(this.peakLimit).append(" connections.").append(JCoRuntime.CRLF).append(this.describeAllocatedClients(this.allocated)).toString();
                JCoException ex = new JCoException(106, "JCO_ERROR_RESOURCE", msg);
                if (Trace.isOn(2)) {
                    Trace.fireTrace(2, new StringBuilder(msg.length() + 125).append("[JCoAPI] PoolingFactory.getClient(): No clients available. Throwing ").append(ex.toString()).toString());
                }
                throw ex;
            }
            this.setMaxUsed(this.getNumUsed());
        }
        try {
            if (client.isValid() && !client.middleware.isAlive(client)) {
                client.disconnect(true);
            }
            if ((client.state & 2) == 0) {
                client.connect();
            }
        }
        catch (JCoException ex) {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.deallocate(client);
                this.mutex.notifyAll();
            }
            if (Trace.isOn(2)) {
                Trace.fireTrace(2, new StringBuilder(100).append("[JCoAPI] PoolingFactory.getClient(): ").append(ex.toString()).toString());
            }
            throw ex;
        }
        client.state = (byte)(client.state | 0x10);
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(70).append("[JCoAPI] PoolingFactory.getClient() returns handle [").append(client.getConnectionHandle()).append('/').append(client.getConversationID()).append(']').toString(), Trace.isOn(128));
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void releaseClient(ClientConnection client) throws JCoException {
        Object object;
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(220).append("[JCoAPI] PoolingFactory.releaseClient() handle [").append(client != null ? Long.valueOf(client.getConnectionHandle()) : "null").append('/').append(client != null ? client.getConversationID() : "null").append("] into pool ").append(this.destinationId).append(" [pool size: ").append(this.getCurrentPoolSize()).append(", peak limit: ").append(this.getPeakLimit()).append(", waiting threads: ").append(this.getNumWaitingThreads()).append(", currently used: ").append(this.getNumUsed()).append(']').toString());
        }
        if (client == null) {
            return;
        }
        if (client.pool == null) {
            client.disconnect(false);
            return;
        }
        Object object2 = this.mutex;
        synchronized (object2) {
            if ((client.state & 0x10) == 0) {
                return;
            }
            client.acquireBusyState("release");
            client.state = (byte)(client.state & 0xFFFFFFEF);
        }
        try {
            char partnerType = this.getAttributes().getPartnerType();
            if (this.capacity <= 0 || partnerType == 'R' || partnerType == 'E' || !client.isAlive()) {
                client.state = (byte)(client.state & 0xFFFFFFFD);
                client.middleware.disconnect(client);
            } else {
                try {
                    client.internalReset();
                }
                catch (JCoException ex) {
                    if (Trace.isOn(2)) {
                        Trace.fireTrace(2, new StringBuilder(100).append("[JCoAPI] PoolingFactory.releaseClient() handle [").append(client.getConnectionHandle()).append("] failed with ").append(ex.toString()).toString());
                    }
                    client.middleware.disconnect(client);
                    throw ex;
                }
            }
            Object var5_6 = null;
            client.releaseBusyState();
            object = this.mutex;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            client.releaseBusyState();
            Object object3 = this.mutex;
            synchronized (object3) {
                this.deallocate(client);
                if (client.isValid()) {
                    if (this.available.getLimit() > 0) {
                        client = this.available.push(client);
                    }
                    if (client != null) {
                        try {
                            client.middleware.disconnect(client);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                this.mutex.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            this.deallocate(client);
            if (client.isValid()) {
                if (this.available.getLimit() > 0) {
                    client = this.available.push(client);
                }
                if (client != null) {
                    try {
                        client.middleware.disconnect(client);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachFromPool(ClientConnection client) throws JCoException {
        if (client == null || client.pool == null) {
            return;
        }
        if ((client.state & 0x10) == 0) {
            JCoException ex = new JCoException(106, "JCO_ERROR_RESOURCE", "A client that is not allocated from a pool cannot be detached");
            if (Trace.isOn(2)) {
                Trace.fireTrace(2, new StringBuilder(100).append("[JCoAPI] PoolingFactory.detachFromPool(): ").append(ex.toString()).toString());
            }
            throw ex;
        }
        if (client.pool != this) {
            JCoException ex = new JCoException(106, "JCO_ERROR_RESOURCE", "A client allocated from pool " + client.pool.getName() + " cannot be detached from " + this.getName() + ".");
            if (Trace.isOn(2)) {
                Trace.fireTrace(2, new StringBuilder(100).append("[JCoAPI] PoolingFactory.detachFromPool(): ").append(ex.toString()).toString());
            }
            throw ex;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.deallocate(client);
            client.pool = null;
            client.state = (byte)(client.state & 0xFFFFFFEF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void attachToPool(ClientConnection client, boolean allocate) throws JCoException {
        client.pool = this;
        Object object = this.mutex;
        synchronized (object) {
            if (allocate) {
                this.allocate(client);
            } else {
                this.releaseClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean isTimedOut(long now) {
        if (now < this.nextExpirationCheck) {
            return false;
        }
        boolean isTimedOut = super.isTimedOut(now);
        Object object = this.mutex;
        synchronized (object) {
            int availableSize = this.available.size();
            if (availableSize > 0) {
                int i = 0;
                while (i < availableSize) {
                    ClientConnection conn = this.available.get(i);
                    if (now - conn.last_active_timestamp > this.expirationTime) {
                        this.available.remove(i);
                        --availableSize;
                        try {
                            conn.disconnect(true);
                        }
                        catch (Exception ex) {
                            if (!Trace.isOn(2)) continue;
                            Trace.fireTrace(2, new StringBuilder(100).append("[JCoAPI] PoolingFactory.isTimedOut(): disconnect caused ").append(ex.toString()).toString());
                        }
                        continue;
                    }
                    ++i;
                }
                isTimedOut = false;
            }
        }
        this.nextExpirationCheck = now + this.getExpirationCheckPeriod();
        return isTimedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        ClientConnection conn;
        Object allocatedCopy = null;
        Object availableCopy = null;
        Object object = this.mutex;
        synchronized (object) {
            if (!this.allocated.isEmpty()) {
                allocatedCopy = this.allocated.clone();
            }
            if (!this.available.isEmpty()) {
                availableCopy = this.available.clone();
            }
        }
        if (allocatedCopy != null) {
            conn = (ClientConnection)((ObjectList)allocatedCopy).pop();
            while (conn != null) {
                monitoredData.add(conn.getMonitoredData());
                conn = (ClientConnection)((ObjectList)allocatedCopy).pop();
            }
        }
        if (availableCopy != null) {
            conn = (ClientConnection)((LimitedList)availableCopy).pop();
            while (conn != null) {
                monitoredData.add(conn.getMonitoredData());
                conn = (ClientConnection)((LimitedList)availableCopy).pop();
            }
        }
    }
}

