/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.Trace;
import java.util.Properties;

public class RfcCustomizedDestination
extends RfcDestination {
    protected RfcCustomizedDestination(String name, Properties properties, String propertiesProvider, RfcDestination parent) {
        super(name, properties, propertiesProvider, parent);
    }

    public String getOriginDestinationID(boolean forRepositoryDestination) {
        if (this.parentDestination == null) {
            return null;
        }
        if (forRepositoryDestination) {
            return this.parentDestination.getRepositoryKey();
        }
        return this.parentDestination.getDestinationID();
    }

    InternalDestination getRepositoryDestination() throws JCoException {
        if (this.repositoryDestination == null) {
            InternalDestination repoDest = super.getRepositoryDestination();
            this.repositoryDestination = repoDest == this ? this.parentDestination : repoDest;
        }
        return this.repositoryDestination;
    }

    public BasicRepository getRepository() throws JCoException {
        super.getRepository();
        if (this.repositoryDestination instanceof RfcCustomizedDestination && this.repository instanceof AbapRepository) {
            AbapRepository abapRepo = (AbapRepository)this.repository;
            abapRepo.destinationList.removeDestination(this.repositoryDestination);
            abapRepo.destinationList.setCurrentDestination(this.repositoryDestination);
            if (Trace.isOn(128)) {
                StringBuilder buffer = new StringBuilder(200);
                buffer.append("[JCoAPI] RfcCustomizedDestination.getRepository() on ").append(this.getDestinationName());
                buffer.append(" adjusted repository ").append(this.repository.getName());
                buffer.append(" to use the custom destination ").append(this.repositoryDestination.getDestinationName()).append(" for repository calls");
                Trace.fireTrace(128, buffer.toString());
            }
        }
        return this.repository;
    }
}

