/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.Trace;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;

public class Jarm {
    private static final byte ON = 1;
    private static final byte IN_CLASSPATH = 2;
    private static byte jarm_state = 0;

    public static boolean setState(String value) {
        if (value == null) {
            return false;
        }
        if ("1".equals(value)) {
            if (!Jarm.isInClasspath()) {
                throw new JCoRuntimeException(155, "JCO_ERROR_JARM_LOAD_ERROR", "jARM library not found in CLASSPATH. Please check CLASSPATH.");
            }
            return true;
        }
        jarm_state = 0;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInClasspath() {
        if ((jarm_state & 1) == 0) {
            try {
                Class.forName("com.sap.util.monitor.jarm.IMonitor");
                jarm_state = (byte)(jarm_state | 2);
            }
            catch (Exception exception) {
            }
            finally {
                jarm_state = (byte)(jarm_state | 1);
            }
        }
        return (jarm_state & 2) != 0;
    }

    public static Monitor getRequestMonitor(String user, String reqName) {
        try {
            if (jarm_state == 3) {
                return new Monitor(TaskMonitor.getRequestMonitor((String)user, (String)reqName), reqName);
            }
        }
        catch (Throwable th) {
            Trace.fireTrace(1, "[JCoAPI] error in JARM:" + th.toString() + ". JARM notification is being turned off.");
            JCo.setProperty("jco.jarm", "0");
        }
        return null;
    }

    public static class Monitor {
        private IMonitor monitor;
        private String reqName = null;
        private String currentComponent = null;

        protected Monitor(IMonitor monitor, String reqName) {
            this.reqName = reqName;
            this.monitor = monitor;
        }

        public void setUser(String user) {
            this.monitor.setUser(user);
        }

        public void startComponent(String name) {
            this.currentComponent = name;
            this.monitor.startComponent(name);
        }

        public void compAction(String compName, String action) {
            this.monitor.compAction(compName, action);
        }

        public void compAction(String action) {
            this.monitor.compAction(this.reqName, action);
        }

        public void endComponent(String name) {
            this.monitor.endComponent(name);
        }

        public void endComponent(String name, long dataSize) {
            this.monitor.endComponent(name, (int)dataSize);
        }

        public void startComponent() {
            this.monitor.startComponent(this.reqName);
        }

        public void endComponent() {
            if (this.currentComponent == null) {
                this.monitor.endComponent(this.reqName);
            } else {
                this.endComponent(this.currentComponent);
                this.currentComponent = null;
            }
        }

        public void endComponent(long dataSize) {
            if (this.currentComponent == null) {
                this.monitor.endComponent(this.reqName);
            } else {
                this.endComponent(this.currentComponent, dataSize);
                this.currentComponent = null;
            }
        }

        public void endRequest() {
            this.monitor.endRequest(this.reqName);
        }

        public void endRequest(long dataSize) {
            this.monitor.endRequest(this.reqName, (int)dataSize);
        }
    }
}

