/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitedList<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6543353670501598971L;
    protected Object[] m_list = null;
    protected int m_first = 0;
    protected int m_end = 0;

    public LimitedList() {
        this(1);
    }

    public LimitedList(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit < 0 [" + limit + "<0]");
        }
        this.m_list = new Object[limit];
    }

    public LimitedList(E[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("objectArray == null");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("objectArray[" + i + "] == null");
        }
        this.m_list = (Object[])objectArray.clone();
    }

    public final void clear() {
        for (int i = this.m_list.length - 1; i >= 0; --i) {
            this.m_list[i] = null;
        }
        this.m_first = 0;
        this.m_end = 0;
    }

    public final void setLimit(int limit) {
        if (limit == this.m_list.length) {
            return;
        }
        int oldSize = this.size();
        if (limit < oldSize) {
            throw new IllegalArgumentException("limit < size() [" + limit + "<" + oldSize + "]");
        }
        Object[] oldList = this.m_list;
        this.m_list = new Object[limit];
        if (oldSize == 0) {
            return;
        }
        if (this.m_end > this.m_first) {
            System.arraycopy(oldList, this.m_first, this.m_list, 0, this.m_end - this.m_first);
        } else {
            int len = oldList.length - this.m_first;
            System.arraycopy(oldList, this.m_first, this.m_list, 0, len);
            System.arraycopy(oldList, 0, this.m_list, len, this.m_end);
        }
        this.m_first = 0;
        this.m_end = limit == oldSize ? 0 : oldSize;
    }

    public final int getLimit() {
        return this.m_list.length;
    }

    public final int size() {
        if (this.m_list.length == 0 || this.m_list[this.m_first] == null) {
            return 0;
        }
        if (this.m_end > this.m_first) {
            return this.m_end - this.m_first;
        }
        if (this.m_end < this.m_first) {
            return this.m_list.length - this.m_first + this.m_end;
        }
        return this.m_list.length;
    }

    public final LimitedList<E> clone() {
        try {
            LimitedList cloned = (LimitedList)super.clone();
            cloned.m_list = (Object[])this.m_list.clone();
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public final boolean contains(E object) {
        return this.indexOf(object, 0, true) > -1;
    }

    public final E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index >= size() [" + index + ">=" + this.size() + "]");
        }
        return (E)this.m_list[(index + this.m_first) % this.m_list.length];
    }

    public final int indexOf(E object) {
        return this.indexOf(object, 0, true);
    }

    public final int indexOf(E object, int startIndex) {
        return this.indexOf(object, startIndex, true);
    }

    public final int indexOf(E object, int startIndex, boolean searchForward) {
        block6: {
            if (startIndex < 0) {
                throw new IndexOutOfBoundsException("startIndex < 0 [" + startIndex + "<0]");
            }
            if (startIndex > 0 && startIndex >= this.size()) {
                throw new IndexOutOfBoundsException("startIndex >= size() [" + startIndex + ">=" + this.size() + "]");
            }
            if (object == null) break block6;
            if (searchForward) {
                int size = this.size();
                for (int i = startIndex; i < size; ++i) {
                    if (!this.m_list[(i + this.m_first) % this.m_list.length].equals(object)) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i >= 0; --i) {
                    if (!this.m_list[(i + this.m_first) % this.m_list.length].equals(object)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.m_list.length == 0 || this.m_list[this.m_first] == null;
    }

    public final int lastIndexOf(E object) {
        if (this.isEmpty()) {
            return -1;
        }
        return this.indexOf(object, this.size() - 1, false);
    }

    public final E pop() {
        if (this.isEmpty()) {
            return null;
        }
        this.m_end = this.m_end > 0 ? --this.m_end : this.m_list.length - 1;
        Object removed = this.m_list[this.m_end];
        this.m_list[this.m_end] = null;
        if (this.m_first == this.m_end) {
            this.m_first = 0;
            this.m_end = 0;
        }
        return (E)removed;
    }

    public final E push(E object) {
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        if (this.m_list.length > 0) {
            Object removed = this.m_list[this.m_end];
            this.m_list[this.m_end] = object;
            ++this.m_end;
            if (this.m_end == this.m_list.length) {
                this.m_end = 0;
            }
            if (removed != null) {
                ++this.m_first;
                if (this.m_first == this.m_list.length) {
                    this.m_first = 0;
                }
                return (E)removed;
            }
        }
        return null;
    }

    public final E remove(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index >= size() [" + index + ">=" + this.size() + "]");
        }
        index = (this.m_first + index) % this.m_list.length;
        Object removed = this.m_list[index];
        this.m_list[index] = this.m_list[this.m_first];
        this.m_list[this.m_first] = null;
        ++this.m_first;
        if (this.m_first == this.m_list.length) {
            this.m_first = 0;
        } else if (this.m_first == this.m_end) {
            this.m_first = 0;
            this.m_end = 0;
        }
        return (E)removed;
    }

    public final boolean remove(E object) {
        int index = this.indexOf(object, 0, true);
        if (index >= 0) {
            this.remove(index);
        }
        return index >= 0;
    }

    public final E set(int index, E object) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index >= size() [" + index + ">=" + this.size() + "]");
        }
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        index = (this.m_first + index) % this.m_list.length;
        Object replaced = this.m_list[index];
        this.m_list[index] = object;
        return (E)replaced;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this.size()];
        System.arraycopy(this.m_list, 0, array, 0, this.size());
        return array;
    }
}

