/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.api.RfcApi;
import java.net.Inet6Address;
import java.net.InetAddress;

public final class AbSysInfo {
    public static final byte SYSINT_LITTLE_ENDIAN = 1;
    public static final byte SYSINT_BIG_ENDIAN = 2;
    public static final byte SYSFLOAT_IEEE = 1;
    public static final byte SYSFLOAT_370 = 2;
    public static final byte intformat;
    public static final byte floatformat = 1;
    public static final boolean littleEndianPlatform;
    public static final boolean nonUnicodePlatform;
    public static final String charset;
    public static final String SapRelease = "721";
    public static String programName;
    public static final String ipAddress;
    public static final String ipv6Address;
    public static final String host;
    public static final String systemID;
    public static final String systemNumber;
    public static final String callerID;
    static final String[] intFormats;
    static final String[] floatFormats;
    static final String[] compressionFormats;
    static final String[] conversionErrorBehavior;

    public static String getIPv4Address(Inet6Address ipv6Address) {
        byte[] address = ipv6Address.getAddress();
        return new StringBuilder(15).append(address[12] & 0xFF).append('.').append(address[13] & 0xFF).append('.').append(address[14] & 0xFF).append('.').append(address[15] & 0xFF).toString();
    }

    static {
        programName = "SAPJCo";
        intFormats = new String[]{"???", "LIT", "BIG"};
        floatFormats = new String[]{"????", "IEEE", "\\370"};
        compressionFormats = new String[]{"", "SPACE", "LZ", "(SPACE)", "(LZ)", "SPACE-U2", "SPACE-U4"};
        conversionErrorBehavior = new String[]{"REJECT", "IGNORE"};
        String name = null;
        String ip = null;
        String ipv6 = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            if (ia instanceof Inet6Address) {
                Inet6Address iav6 = (Inet6Address)ia;
                if (iav6.isIPv4CompatibleAddress()) {
                    ip = AbSysInfo.getIPv4Address(iav6);
                }
                ipv6 = iav6.getHostAddress();
            } else {
                ip = ia.getHostAddress();
                ipv6 = null;
            }
            name = ia.getHostName();
        }
        catch (Exception exc) {
            ip = "127.0.0.1";
            ipv6 = null;
            name = "localhost";
        }
        ipAddress = ip;
        ipv6Address = ipv6;
        host = name;
        String ownCodepage = null;
        boolean littleEndian = false;
        try {
            ownCodepage = RfcApi.runtime.getOwnCodepage();
            littleEndian = RfcApi.runtime.isLittleEndian();
        }
        catch (Exception exc) {
            // empty catch block
        }
        nonUnicodePlatform = ownCodepage != null && !ownCodepage.startsWith("410");
        littleEndianPlatform = littleEndian;
        if (littleEndian) {
            intformat = 1;
            charset = "4103";
        } else {
            intformat = (byte)2;
            charset = "4102";
        }
        if (Environment.inStandalone()) {
            systemID = "";
            systemNumber = "";
            callerID = host;
        } else {
            String param = JCoRuntime.getProfileParameter("SAPSYSTEMNAME");
            systemID = param != null ? param : "";
            param = JCoRuntime.getProfileParameter("SAPSYSTEM");
            String string = systemNumber = param != null ? param : "";
            callerID = Environment.inJTS() ? (host != null && systemID.length() > 0 && systemNumber.length() > 0 ? new StringBuilder(host.length() + 7).append(host).append('_').append(systemID).append('_').append(systemNumber).toString() : host) : host;
        }
    }
}

