/*
 * Decompiled with CFR 0.152.
 */
package com.github.sogyf.rabbitmq;

import com.github.sogyf.rabbitmq.util.MsgMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import com.google.common.primitives.Ints;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQInitialize {
    public static final RabbitMQInitialize me = new RabbitMQInitialize();
    private static final ConnectionFactory factory = new ConnectionFactory();
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQInitialize.class);
    private static MsgMapper mapper = null;
    private static boolean consumersActive = true;
    private Properties configurationProp;

    private RabbitMQInitialize() {
    }

    public static void consumersActive(boolean b) {
        consumersActive = b;
    }

    public static void build() {
        RabbitMQInitialize.build(null);
    }

    public static void build(Properties properties) {
        if (properties == null) {
            properties = RabbitMQInitialize.loadDefaultProperties();
        }
        if (properties.containsKey("url")) {
            URI rabbitmqUri;
            String rabbitmqUrl = properties.getProperty("url");
            try {
                rabbitmqUri = new URI(rabbitmqUrl);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to parse url (" + rabbitmqUrl + ")", e);
            }
            properties.setProperty("host", rabbitmqUri.getHost());
            int port = rabbitmqUri.getPort();
            properties.setProperty("port", port <= 0 ? "5672" : Integer.toString(port));
            if (rabbitmqUri.getPath().length() > 1) {
                properties.setProperty("vhost", rabbitmqUri.getPath().substring(1));
            }
            if (rabbitmqUri.getUserInfo() != null) {
                String[] rabbitmqUserInfo = rabbitmqUri.getUserInfo().split(":");
                properties.setProperty("username", rabbitmqUserInfo[0]);
                properties.setProperty("password", rabbitmqUserInfo[1]);
            }
        }
        me.configuration(properties);
        me.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadDefaultProperties() {
        URL defaultRabbitMqURL = Resources.getResource((String)"rabbitmq.properties");
        ByteSource byteSource = Resources.asByteSource((URL)defaultRabbitMqURL);
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = byteSource.openBufferedStream();
            properties.load(inputStream);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return properties;
    }

    private void configuration(Properties properties) {
        this.configurationProp = properties;
    }

    private void init() {
        factory.setUsername(this.getUserName());
        factory.setPassword(this.getPassword());
        factory.setVirtualHost(this.getVhost());
    }

    public boolean areConsumersActive() {
        return consumersActive;
    }

    public MsgMapper mapper() {
        if (mapper != null) {
            return mapper;
        }
        String s = this.configurationProp.getProperty("msgmapper");
        if (s != null && StringUtils.isNotBlank((CharSequence)s)) {
            try {
                mapper = MsgMapper.Type.valueOf(s).get();
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
                mapper = MsgMapper.Type.json.get();
            }
        } else {
            mapper = MsgMapper.Type.json.get();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RabbitMQ Message Mapper: %s", (Object)mapper);
        }
        if (mapper == null) {
            throw new RuntimeException("RabbitMQ Message Mapper is null! Config Parameter 'msgmapper': " + s);
        }
        return mapper;
    }

    protected Channel createChannel() {
        Channel channel;
        int attempts = 0;
        while (true) {
            ++attempts;
            if (logger.isDebugEnabled()) {
                logger.info("Attempting to connect to queue: attempt " + attempts);
            }
            try {
                Connection connection = this.getConnection();
                channel = connection.createChannel();
            }
            catch (IOException e) {
                logger.error("Error creating RabbitMQ channel, retrying in 5 secs ", (Throwable)e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return channel;
    }

    public Channel createChannel(String queue, String routingKey) throws Exception {
        int attempts = 0;
        Channel channel = this.createChannel();
        if (me.isBasicQos()) {
            int prefetchCount = 1;
            channel.basicQos(prefetchCount);
        }
        while (true) {
            ++attempts;
            if (logger.isDebugEnabled()) {
                logger.debug("Retry " + attempts);
            }
            try {
                channel.exchangeDeclare(queue, me.getExchangeType(), true);
                channel.queueDeclare(queue, me.isDurable(), false, false, null);
                channel.queueBind(queue, queue, routingKey);
                if (logger.isDebugEnabled()) {
                    logger.info("RabbitMQ Task Channel Available: " + channel);
                }
                return channel;
            }
            catch (Throwable t) {
                logger.error("Error establishing a connection to RabbitMQ, will keep retrying", t);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public Channel createSubscribersChannel(String exchangeName, String queue, String routingKey) throws Exception {
        int attempts = 0;
        Channel channel = this.createChannel();
        if (me.isBasicQos()) {
            int prefetchCount = 1;
            channel.basicQos(prefetchCount);
        }
        while (true) {
            ++attempts;
            if (logger.isDebugEnabled()) {
                logger.debug("Retry " + attempts);
            }
            try {
                String exchangeType = me.getExchangeType();
                channel.exchangeDeclare(exchangeName, exchangeType, true);
                boolean durable = me.isDurable();
                channel.queueDeclare(queue, durable, false, false, null);
                channel.queueBind(queue, exchangeName, routingKey);
                if (logger.isDebugEnabled()) {
                    logger.debug("RabbitMQ Task Channel Available: " + channel);
                }
                return channel;
            }
            catch (Throwable t) {
                logger.error("Error establishing a connection to RabbitMQ, will keep retrying");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public Channel createPublishersChannel(String exchangeName) throws Exception {
        int attempts = 0;
        Channel channel = this.createChannel();
        if (me.isBasicQos()) {
            int prefetchCount = 1;
            channel.basicQos(prefetchCount);
        }
        while (true) {
            ++attempts;
            if (logger.isDebugEnabled()) {
                logger.debug("Retry " + attempts);
            }
            try {
                channel.exchangeDeclare(exchangeName, me.getExchangeType(), true);
                if (logger.isDebugEnabled()) {
                    logger.debug("RabbitMQ Task Channel Available: " + channel);
                }
                return channel;
            }
            catch (Throwable t) {
                logger.error("Error establishing a connection to RabbitMQ, will keep retrying", t);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private String getUserName() {
        String s = this.configurationProp.getProperty("username");
        if (s == null) {
            return "guest";
        }
        return s;
    }

    private String getPassword() {
        String s = this.configurationProp.getProperty("password");
        if (s == null) {
            return "guest";
        }
        return s;
    }

    public boolean isAutoAck() {
        String s = this.configurationProp.getProperty("autoAck");
        return s != null && Boolean.parseBoolean(s);
    }

    private boolean isBasicQos() {
        String s = this.configurationProp.getProperty("basicQos");
        return s == null || Boolean.parseBoolean(s);
    }

    public int retries() {
        int defaultRetries = 5;
        try {
            return Integer.valueOf(this.configurationProp.getProperty("retries", String.valueOf(defaultRetries)));
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return defaultRetries;
        }
    }

    private boolean isDurable() {
        String s = this.configurationProp.getProperty("durable");
        return s == null || Boolean.parseBoolean(s);
    }

    public AMQP.BasicProperties getBasicProperties() {
        if (!this.isDurable()) {
            return null;
        }
        return MessageProperties.PERSISTENT_TEXT_PLAIN;
    }

    private String getExchangeType() {
        String s = this.configurationProp.getProperty("exchangeType");
        if (s == null) {
            return "direct";
        }
        return s;
    }

    private String getVhost() {
        String s = this.configurationProp.getProperty("vhost");
        if (s == null) {
            return "/";
        }
        return s;
    }

    private Address[] getAddress(String seeds) {
        String[] stringArray;
        ArrayList addresses = Lists.newArrayList();
        if (seeds == null || seeds.isEmpty()) {
            addresses.add(new Address("localhost", 5672));
            return addresses.toArray(new Address[0]);
        }
        for (String s : stringArray = seeds.split("[;,\\s]")) {
            String[] hostPort = s.split(":");
            if (0 == hostPort.length) continue;
            String host = hostPort[0];
            int port = 5672;
            if (hostPort.length > 1) {
                port = Integer.parseInt(hostPort[1]);
            }
            addresses.add(new Address(host, port));
        }
        return addresses.toArray(new Address[0]);
    }

    private Connection getConnection() throws IOException, TimeoutException {
        String seeds = this.configurationProp.getProperty("seeds");
        if (Strings.isNullOrEmpty((String)seeds)) {
            String host = this.configurationProp.getProperty("host", "localhost");
            String port = this.configurationProp.getProperty("port", "3679");
            Address address = new Address(host, ((Integer)MoreObjects.firstNonNull((Object)Ints.tryParse((String)port), (Object)3679)).intValue());
            return factory.newConnection(new Address[]{address});
        }
        return factory.newConnection(this.getAddress(seeds));
    }

    public void stop() {
        this.configurationProp = null;
    }
}

