/*
 * Decompiled with CFR 0.152.
 */
package com.github.sogyf.rabbitmq.consumer;

import com.github.sogyf.rabbitmq.consumer.RabbitMQConsumer;
import com.github.sogyf.rabbitmq.exception.RabbitMQNotRetriableException;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQMessageConsumerJob<T> {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQConsumer.class);
    private T message;
    private RabbitMQConsumer consumer;
    private int retries;
    private Channel channel;
    private long deliveryTag;
    private String queue;

    public RabbitMQMessageConsumerJob(Channel channel, long deliveryTag, String queue, RabbitMQConsumer consumer, T message, int retries) {
        this.consumer = consumer;
        this.message = message;
        this.retries = retries;
        this.channel = channel;
        this.deliveryTag = deliveryTag;
        this.queue = queue;
    }

    public void doJob() {
        boolean success = false;
        Throwable exception = null;
        for (int retryCount = 0; retryCount < this.retries + 1; ++retryCount) {
            if (retryCount > 0) {
                logger.info("Retrying to process message (%s) by consumer (%s) on queue (%s). Attempt %s of %s total retries.", new Object[]{this.message, this.consumer, this.queue, retryCount, this.retries});
            }
            try {
                this.consumer.consume(this.message);
                success = true;
            }
            catch (RabbitMQNotRetriableException e) {
                retryCount = Integer.MAX_VALUE;
                exception = e;
                logger.error("Error processing message (%s) with consumer (%s). ", new Object[]{this.message, this.consumer, exception});
                break;
            }
            catch (Throwable t) {
                exception = t;
                logger.error("Error processing message (%s) with consumer (%s). ", new Object[]{this.message, this.consumer, exception});
            }
            if (success) break;
        }
        if (!success) {
            logger.error("Final error processing message (%s) with consumer (%s). Last Exception: %s", new Object[]{this.message, this.consumer, exception});
        }
        try {
            this.channel.basicAck(this.deliveryTag, false);
        }
        catch (Throwable e) {
            logger.error("Error doing a basicAck for tag: " + this.deliveryTag, e);
        }
        if (this.channel != null && this.channel.getConnection() != null && this.channel.getConnection().isOpen()) {
            try {
                this.channel.getConnection().close();
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
    }
}

