/*
 * Decompiled with CFR 0.152.
 */
package com.github.sogyf.rabbitmq.producer;

import com.github.sogyf.rabbitmq.producer.RabbitMQPublisher;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RabbitMQFirehose<T> {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQFirehose.class);

    public void doJob() {
        while (true) {
            try {
                while (true) {
                    int itemsCount = 0;
                    List<T> items = this.getData(this.batchSize());
                    if (items != null && items.size() > 0) {
                        itemsCount = items.size();
                        for (T item : items) {
                            try {
                                RabbitMQPublisher.publish(this.queueName(), this.routingKey(item), item);
                            }
                            catch (Throwable t) {
                                logger.error(t.getMessage(), t);
                            }
                        }
                    }
                    if (items == null) {
                        logger.warn("No data available from firehose %s - quitting process...", (Object)this);
                        return;
                    }
                    if (itemsCount >= this.batchSize()) continue;
                    Thread.sleep(this.sleepInBetweenBatches());
                }
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
                continue;
            }
            break;
        }
    }

    protected abstract List<T> getData(int var1) throws Exception;

    protected String routingKey(T t) {
        return this.queueName();
    }

    protected abstract int batchSize();

    protected abstract String queueName();

    protected long sleepInBetweenBatches() {
        long l = 1000L;
        l *= 60L;
        return l *= 5L;
    }
}

