/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceUtil;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.StreamRepositoryService;

public class DefaultRepositoryService
implements StreamRepositoryService {
    private JasperReportsContext jasperReportsContext;
    private ClassLoader classLoader;
    private URLStreamHandlerFactory urlHandlerFactory;
    private FileResolver fileResolver;

    public DefaultRepositoryService() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public DefaultRepositoryService(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setURLStreamHandlerFactory(URLStreamHandlerFactory urlHandlerFactory) {
        this.urlHandlerFactory = urlHandlerFactory;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    @Override
    public void setContext(RepositoryContext context) {
    }

    @Override
    public void revertContext() {
    }

    @Override
    public InputStream getInputStream(String uri) {
        try {
            URL url = JRResourcesUtil.createURL(uri, this.urlHandlerFactory);
            if (url != null) {
                return JRLoader.getInputStream(url);
            }
            File file = JRResourcesUtil.resolveFile(uri, this.fileResolver);
            if (file != null) {
                return JRLoader.getInputStream(file);
            }
            url = JRResourcesUtil.findClassLoaderResource(uri, this.classLoader);
            if (url != null) {
                return JRLoader.getInputStream(url);
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource getResource(String uri) {
        throw new JRRuntimeException("Not implemented.");
    }

    @Override
    public void saveResource(String uri, Resource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        PersistenceService persistenceService = PersistenceUtil.getInstance(this.jasperReportsContext).getService(DefaultRepositoryService.class, resourceType);
        if (persistenceService != null) {
            return (K)persistenceService.load(uri, this);
        }
        return null;
    }
}

