/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.form.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Preconditions;
import com.jtech.marble.exception.DaoException;
import com.jtech.toa.form.dao.FormDesingerMapper;
import com.jtech.toa.form.domain.Form;
import com.jtech.toa.form.domain.FormDesinger;
import com.jtech.toa.form.model.dto.FormDesignerDto;
import com.jtech.toa.form.service.IFormDesingerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormDesingerServiceImpl
extends ServiceImpl<FormDesingerMapper, FormDesinger>
implements IFormDesingerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDesingerServiceImpl.class);

    @Override
    @Transactional
    public FormDesinger saveFrom(FormDesignerDto formDesignerDto, String formDesingerData, Form form) {
        boolean state;
        Preconditions.checkNotNull((Object)((Object)form), (Object)"\u8868\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Long formId = form.getId();
        Preconditions.checkNotNull((Object)formId, (Object)"\u8868\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        FormDesinger formDesinger = (FormDesinger)((Object)((FormDesingerMapper)this.baseMapper).selectById(formId));
        if (formDesinger == null) {
            formDesinger = new FormDesinger();
            formDesinger.setFormId(formId);
            formDesinger.setDesingerJson(formDesingerData);
            int insertRows = ((FormDesingerMapper)this.baseMapper).insert((Object)formDesinger);
            state = insertRows > 0;
        } else {
            formDesinger.setDesingerJson(formDesingerData);
            int updateRows = ((FormDesingerMapper)this.baseMapper).updateById((Object)formDesinger);
            boolean bl = state = updateRows > 0;
        }
        if (!state) {
            LOGGER.error("form desinger save error!");
            throw new DaoException("\u8868\u5355\u8bbe\u8ba1\u4fe1\u606f\u4fdd\u5b58\u6570\u636e\u64cd\u4f5c\u5931\u8d25");
        }
        return formDesinger;
    }

    @Override
    @Transactional(readOnly=true)
    public FormDesinger selectByProcessId(long processId) {
        if (processId <= 0L) {
            LOGGER.error("processId is null");
            return null;
        }
        return ((FormDesingerMapper)this.baseMapper).selectByProcessId(processId);
    }
}

