/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.sys.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.sys.dao.AttachmentMapper;
import com.jtech.toa.sys.domain.Attachment;
import com.jtech.toa.sys.exception.FileTypeException;
import com.jtech.toa.sys.service.IAttachmentService;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.io.FileTypeUtil;
import com.xiaoleilu.hutool.io.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttachmentServiceImpl
extends ServiceImpl<AttachmentMapper, Attachment>
implements IAttachmentService {
    @Override
    public Attachment savePicture(File pictureFile, String fileSavePath, String uploadFileName, ShiroUser shiroUser) {
        try {
            return this.savePictureAttachment(pictureFile, fileSavePath, uploadFileName, shiroUser);
        }
        catch (IOException e) {
            throw new FileTypeException("file type is not image");
        }
    }

    private Attachment savePictureAttachment(File imageFile, String fileSavePath, String uploadFileName, ShiroUser shiroUser) throws IOException {
        String fileType = FileTypeUtil.getType((File)imageFile);
        BufferedImage buff = ImageIO.read(imageFile);
        int imageWidth = buff == null ? 0 : buff.getWidth();
        int imageHeight = buff == null ? 0 : buff.getHeight();
        return this.saveAttachment(imageFile, fileSavePath, fileType, uploadFileName, shiroUser.getId(), imageWidth, imageHeight);
    }

    @Override
    public String genDatePath() {
        String yyyyMMdd = DateUtil.yyyyMMddDash((Date)new Date());
        return StringUtils.replace((String)yyyyMMdd, (String)"-", (String)File.separator);
    }

    @Transactional
    public Attachment saveAttachment(File file, String fileSavePath, String fileType, String uploadFileName, long uploader, int imageWidth, int imageHeight) {
        String absolutePath = file.getAbsolutePath();
        String relativePath = StringUtils.replace((String)absolutePath, (String)fileSavePath, (String)"");
        String md5Hash = SecureUtil.md5((File)file);
        Attachment hashAttachment = ((AttachmentMapper)this.baseMapper).selectByHash(md5Hash);
        if (hashAttachment != null) {
            return hashAttachment;
        }
        long fileSize = FileUtil.size((File)file);
        int unixTime = DateUtil.unixTime();
        Attachment attachment = new Attachment();
        attachment.setDateline(unixTime);
        attachment.setFileName(uploadFileName);
        attachment.setFileSize(fileSize);
        attachment.setFileType(fileType);
        attachment.setHash(md5Hash);
        attachment.setFilePath(relativePath);
        attachment.setUploader(uploader);
        if (imageWidth > 0) {
            attachment.setImageFlag(true);
        }
        attachment.setImageWidth(imageWidth);
        attachment.setImageHeight(imageHeight);
        attachment.setUrl(StringUtils.replace((String)relativePath, (String)"\\", (String)"/"));
        Integer insertRows = ((AttachmentMapper)this.baseMapper).insert((Object)attachment);
        if (insertRows > 0) {
            return attachment;
        }
        throw new DaoException("\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f\u5931\u8d25");
    }

    @Override
    @Transactional
    public Attachment saveFile(File file, String fileSavePath, String uploldFileName, ShiroUser shiroUser) {
        String fileType = "";
        try {
            fileType = FileTypeUtil.getType((File)file);
            if (StringUtils.equals((CharSequence)fileType, (CharSequence)"bmp") || StringUtils.equals((CharSequence)fileType, (CharSequence)"gif") || StringUtils.equals((CharSequence)fileType, (CharSequence)"jpg") || StringUtils.equals((CharSequence)fileType, (CharSequence)"jpeg") || StringUtils.equals((CharSequence)fileType, (CharSequence)"png")) {
                return this.savePictureAttachment(file, fileSavePath, uploldFileName, shiroUser);
            }
            return this.saveAttachment(file, fileSavePath, fileType, uploldFileName, shiroUser.getId(), 0, 0);
        }
        catch (IOException e) {
            throw new FileTypeException("save file has error!", fileType);
        }
    }
}

