/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.sys.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.util.text.StrUtil;
import com.jtech.toa.sys.dao.CodeFormatMapper;
import com.jtech.toa.sys.domain.CodeFormat;
import com.jtech.toa.sys.model.dto.CodeFormatFormDto;
import com.jtech.toa.sys.model.query.CodeFormatQuery;
import com.jtech.toa.sys.service.ICodeFormatService;
import com.jtech.toa.sys.service.ICodeItemRfService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CodeFormatServiceImpl
extends ServiceImpl<CodeFormatMapper, CodeFormat>
implements ICodeFormatService {
    private final ICodeItemRfService codeItemRfService;

    @Autowired
    public CodeFormatServiceImpl(ICodeItemRfService codeItemRfService) {
        this.codeItemRfService = codeItemRfService;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CodeFormat> selectAll() {
        return ((CodeFormatMapper)this.baseMapper).selectByAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Page<CodeFormat> findByPagination(Page<CodeFormat> pageResult, List<Sort.Order> orders) {
        List<CodeFormat> codeFormats = ((CodeFormatMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(codeFormats);
        return pageResult;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<CodeFormat> requestPage, CodeFormatQuery codeFormatQuery) {
        List<CodeFormat> codeFormats = ((CodeFormatMapper)this.baseMapper).selectByQuery(requestPage, codeFormatQuery);
        requestPage.setRecords(codeFormats);
    }

    @Override
    @Transactional
    public boolean insertCodeFormat(CodeFormatFormDto codeFormatFormDto, ShiroUser shiroUser) {
        long shiroUserId = shiroUser.getId();
        int curTime = DateUtil.unixTime();
        CodeFormat codeFormat = codeFormatFormDto.toCodeFormat();
        codeFormat.setId(null);
        codeFormat.setDeleteFlag(0);
        codeFormat.setUpdater(shiroUserId);
        codeFormat.setUpdateTime(curTime);
        codeFormat.setCreater(shiroUserId);
        codeFormat.setCreateTime(curTime);
        int rows = ((CodeFormatMapper)this.baseMapper).insert((Object)codeFormat);
        if (rows < 0) {
            throw new DaoException("\u6dfb\u52a0\u7f16\u7801\u89c4\u5219\u5931\u8d25");
        }
        List codeItemIds = StrUtil.split((String)codeFormatFormDto.getItemIds(), (String)",");
        boolean res = this.codeItemRfService.batchInsertCodeItemRf(codeItemIds, codeFormat.getId());
        if (!res) {
            throw new DaoException("\u6279\u91cf\u6dfb\u52a0\u89c4\u5219\u9879\u5173\u8054\u8868\u5931\u8d25");
        }
        return true;
    }

    @Override
    public CodeFormatFormDto findByCodeFormId(long id) {
        return ((CodeFormatMapper)this.baseMapper).findByCodeFormatId(id);
    }

    @Override
    @Transactional
    public boolean removeCodeFormat(long id) {
        int res = this.codeItemRfService.deleteByCodeFormatId(id);
        if (res < 0) {
            throw new DaoException("\u6279\u91cf\u5220\u9664\u89c4\u5219\u5173\u8054\u8868\u4fe1\u606f\u5931\u8d25");
        }
        CodeFormat codeFormat = (CodeFormat)((Object)((CodeFormatMapper)this.baseMapper).selectById(Long.valueOf(id)));
        codeFormat.setDeleteFlag(1);
        int rows = ((CodeFormatMapper)this.baseMapper).updateById((Object)codeFormat);
        if (rows < 0) {
            throw new DaoException("\u5220\u9664\u7f16\u7801\u89c4\u5219\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateCodeFormat(CodeFormatFormDto codeFormatFormDto, ShiroUser shiroUser) {
        long shiroUserId = shiroUser.getId();
        int curTime = DateUtil.unixTime();
        int rows = this.codeItemRfService.deleteByCodeFormatId(codeFormatFormDto.getId());
        if (rows < 0) {
            throw new DaoException("\u6279\u91cf\u5220\u9664\u89c4\u5219\u5173\u8054\u8868\u4fe1\u606f\u5931\u8d25");
        }
        CodeFormat codeFormat = (CodeFormat)((Object)((CodeFormatMapper)this.baseMapper).selectById(codeFormatFormDto.getId()));
        codeFormat.setName(codeFormatFormDto.getName());
        codeFormat.setDivision(codeFormatFormDto.getDivision());
        codeFormat.setUpdater(shiroUserId);
        codeFormat.setUpdateTime(curTime);
        rows = ((CodeFormatMapper)this.baseMapper).updateById((Object)codeFormat);
        if (rows < 0) {
            throw new DaoException("\u66f4\u65b0\u7f16\u7801\u89c4\u5219\u5931\u8d25");
        }
        List codeItemIds = StrUtil.split((String)codeFormatFormDto.getItemIds(), (String)",");
        boolean res = this.codeItemRfService.batchInsertCodeItemRf(codeItemIds, codeFormat.getId());
        if (!res) {
            throw new DaoException("\u6279\u91cf\u6dfb\u52a0\u89c4\u5219\u9879\u5173\u8054\u8868\u5931\u8d25");
        }
        return true;
    }
}

