/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.sys.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.sys.dao.CodeItemMapper;
import com.jtech.toa.sys.domain.CodeItem;
import com.jtech.toa.sys.model.query.CodeItemQuery;
import com.jtech.toa.sys.service.ICodeItemService;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CodeItemServiceImpl
extends ServiceImpl<CodeItemMapper, CodeItem>
implements ICodeItemService {
    @Override
    @Transactional(readOnly=true)
    public Page<CodeItem> findByPagination(Page<CodeItem> pageResult, List<Sort.Order> orders) {
        List<CodeItem> codeItems = ((CodeItemMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(codeItems);
        return pageResult;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<CodeItem> requestPage, CodeItemQuery codeItemQuery) {
        List<CodeItem> codeItems = ((CodeItemMapper)this.baseMapper).selectByQuery(requestPage, codeItemQuery);
        requestPage.setRecords(codeItems);
    }

    @Override
    public boolean addCodeItem(CodeItem codeItem, ShiroUser shiroUser) {
        long shiroUserId = shiroUser.getId();
        int curTime = DateUtil.unixTime();
        codeItem.setDeleteFlag(0);
        codeItem.setId(null);
        codeItem.setUpdater(shiroUserId);
        codeItem.setUpdateTime(curTime);
        codeItem.setCreater(shiroUserId);
        codeItem.setCreateTime(curTime);
        return ((CodeItemMapper)this.baseMapper).insert((Object)codeItem) == 1;
    }

    @Override
    public boolean removeCodeItem(long id) {
        CodeItem codeItem = new CodeItem();
        codeItem.setId(id);
        codeItem.setDeleteFlag(1);
        return ((CodeItemMapper)this.baseMapper).updateById((Object)codeItem) == 1;
    }

    @Override
    @Transactional
    public boolean updateCodeItem(CodeItem codeItem, ShiroUser shiroUser) {
        long shiroUserId = shiroUser.getId();
        int curTime = DateUtil.unixTime();
        CodeItem temp = new CodeItem();
        temp.setId(codeItem.getId());
        temp.setDatePattern("");
        temp.setTxtPrefix("");
        temp.setBizType("000");
        temp.setScript("");
        temp.setSnDigits(0);
        temp.setDailyRebuid(0);
        temp.setCodeTable("");
        temp.setCodeField("");
        temp.setCodeTable("");
        int rows = ((CodeItemMapper)this.baseMapper).updateById((Object)temp);
        if (rows < 0) {
            throw new DaoException("\u91cd\u7f6e\u5f53\u524d\u89c4\u5219\u9879\u5931\u8d25\uff01");
        }
        codeItem.setUpdater(shiroUserId);
        codeItem.setUpdateTime(curTime);
        return ((CodeItemMapper)this.baseMapper).updateById((Object)codeItem) == 1;
    }
}

