/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.user.service.impl;

import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.shiro.ShiroUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.util.text.StrUtil;
import com.jtech.toa.user.dao.OrganizationPositionMapper;
import com.jtech.toa.user.domain.Employee;
import com.jtech.toa.user.domain.OrganizationPosition;
import com.jtech.toa.user.domain.PositionEmployee;
import com.jtech.toa.user.model.OrganizationPositionDto;
import com.jtech.toa.user.model.PositionEmployeeDto;
import com.jtech.toa.user.model.query.OrganizationPositionQuery;
import com.jtech.toa.user.service.IEmployeeService;
import com.jtech.toa.user.service.IOrganizationPositionService;
import com.jtech.toa.user.service.IPositionEmployeeService;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrganizationPositionServiceImpl
extends ServiceImpl<OrganizationPositionMapper, OrganizationPosition>
implements IOrganizationPositionService {
    private final IPositionEmployeeService positionEmployeeService;
    private final IdentityService identityService;
    private final IEmployeeService employeeService;

    @Autowired
    public OrganizationPositionServiceImpl(IPositionEmployeeService positionEmployeeService, IdentityService identityService, IEmployeeService employeeService) {
        this.positionEmployeeService = positionEmployeeService;
        this.identityService = identityService;
        this.employeeService = employeeService;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<OrganizationPosition> requestPage, OrganizationPositionQuery organizationPositionQuery) {
        List<OrganizationPosition> organizationPositions = ((OrganizationPositionMapper)this.baseMapper).selectByQuery(requestPage, organizationPositionQuery);
        requestPage.setRecords(organizationPositions);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<OrganizationPosition> findByPagination(Page<OrganizationPosition> pageResult, List<Sort.Order> orders) {
        List<OrganizationPosition> organizationPositions = ((OrganizationPositionMapper)this.baseMapper).findByPagination(pageResult, orders);
        pageResult.setRecords(organizationPositions);
        return pageResult;
    }

    @Override
    @Transactional
    public boolean addPosition(OrganizationPositionDto organizationPositionDto) {
        ShiroUser user = ShiroUtil.getUser();
        long loginUserId = user.getId();
        Integer dateNow = DateUtil.unixTime();
        String MemberIds = organizationPositionDto.getMemberIds();
        OrganizationPosition organizationPosition = new OrganizationPosition();
        organizationPosition.setOrgId(organizationPositionDto.getOrgId());
        organizationPosition.setName(organizationPositionDto.getName());
        organizationPosition.setPositionId(organizationPositionDto.getPositionId());
        organizationPosition.setBookSize(organizationPositionDto.getBookSize());
        organizationPosition.setMemberNames(organizationPositionDto.getMemberNames());
        organizationPosition.setUpdater(loginUserId);
        organizationPosition.setUpdateTime(dateNow);
        organizationPosition.setCreater(loginUserId);
        organizationPosition.setCreateTime(dateNow);
        organizationPosition.setDeleteFlag(0);
        List employeeIds = null;
        if (MemberIds == null) {
            organizationPosition.setMemberSize(0);
        } else {
            employeeIds = StrUtil.split((String)MemberIds, (String)",");
            organizationPosition.setMemberSize(employeeIds.size());
        }
        int rows = ((OrganizationPositionMapper)this.baseMapper).insert((Object)organizationPosition);
        if (rows < 0) {
            throw new DaoException("insert org_organization_position error");
        }
        Group newGroup = this.identityService.newGroup(String.valueOf(organizationPosition.getId()));
        newGroup.setName(String.valueOf(organizationPosition.getId()));
        this.identityService.saveGroup(newGroup);
        boolean res = this.batchInsertPositionEmployee(employeeIds, organizationPosition);
        if (!res) {
            throw new DaoException("insert org_position_employee error");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updatePosition(OrganizationPositionDto organizationPositionDto) {
        boolean res = this.batchDeletePositionEmployee(organizationPositionDto.getId());
        if (!res) {
            throw new DaoException("update org_position_employee error");
        }
        ShiroUser user = ShiroUtil.getUser();
        long loginUserId = user.getId();
        Integer dateNow = DateUtil.unixTime();
        String MemberIds = organizationPositionDto.getMemberIds();
        OrganizationPosition organizationPosition = new OrganizationPosition();
        organizationPosition.setId(organizationPositionDto.getId());
        organizationPosition.setName(organizationPositionDto.getName());
        organizationPosition.setPositionId(organizationPositionDto.getPositionId());
        organizationPosition.setBookSize(organizationPositionDto.getBookSize());
        organizationPosition.setMemberNames(organizationPositionDto.getMemberNames());
        organizationPosition.setUpdater(loginUserId);
        organizationPosition.setUpdateTime(dateNow);
        organizationPosition.setDeleteFlag(0);
        List employeeIds = null;
        if (MemberIds == null) {
            organizationPosition.setMemberSize(0);
        } else {
            employeeIds = StrUtil.split((String)MemberIds, (String)",");
            organizationPosition.setMemberSize(employeeIds.size());
        }
        int rows = ((OrganizationPositionMapper)this.baseMapper).updateById((Object)organizationPosition);
        Group activitiGroup = (Group)this.identityService.createGroupQuery().groupId(String.valueOf(organizationPosition.getId())).singleResult();
        if (activitiGroup != null) {
            activitiGroup.setName(String.valueOf(organizationPosition.getId()));
            this.identityService.saveGroup(activitiGroup);
        } else {
            activitiGroup = this.identityService.newGroup(String.valueOf(organizationPosition.getId()));
            activitiGroup.setName(String.valueOf(organizationPosition.getId()));
            this.identityService.saveGroup(activitiGroup);
        }
        if (rows < 0) {
            throw new DaoException("update org_organization_position error!");
        }
        res = this.batchInsertPositionEmployee(employeeIds, organizationPosition);
        if (!res) {
            throw new DaoException("insert org_position_employee error");
        }
        return true;
    }

    @Override
    @Transactional(readOnly=true)
    public OrganizationPositionDto getOrganizationPositionDto(long orgPositionId) {
        OrganizationPositionDto organizationPositionDto = new OrganizationPositionDto();
        OrganizationPosition organizationPosition = (OrganizationPosition)((Object)((OrganizationPositionMapper)this.baseMapper).selectById(Long.valueOf(orgPositionId)));
        organizationPositionDto.setId(organizationPosition.getId());
        organizationPositionDto.setBookSize(organizationPosition.getBookSize());
        organizationPositionDto.setName(organizationPosition.getName());
        organizationPositionDto.setOrgId(organizationPosition.getOrgId());
        organizationPositionDto.setPositionId(organizationPosition.getPositionId());
        List<PositionEmployeeDto> positionEmployeeDtos = this.positionEmployeeService.selectByOrgPositionId(orgPositionId);
        if (positionEmployeeDtos.size() > 0) {
            StringBuilder employeeNames = new StringBuilder();
            StringBuilder employeeIds = new StringBuilder();
            for (int i = 0; i < positionEmployeeDtos.size(); ++i) {
                if (i == positionEmployeeDtos.size() - 1) {
                    employeeNames.append(positionEmployeeDtos.get(i).getUsername());
                    employeeIds.append(positionEmployeeDtos.get(i).getId());
                    continue;
                }
                employeeNames.append(positionEmployeeDtos.get(i).getUsername()).append(",");
                employeeIds.append(positionEmployeeDtos.get(i).getId()).append(",");
            }
            organizationPositionDto.setMemberNames(employeeNames.toString());
            organizationPositionDto.setMemberIds(employeeIds.toString());
        }
        return organizationPositionDto;
    }

    @Override
    @Transactional
    public boolean deletePosition(long id) {
        boolean res = this.batchDeletePositionEmployee(id);
        if (!res) {
            throw new DaoException("update org_position_employee error");
        }
        OrganizationPosition organizationPosition = new OrganizationPosition();
        organizationPosition.setId(id);
        organizationPosition.setDeleteFlag(1);
        int rows = ((OrganizationPositionMapper)this.baseMapper).updateById((Object)organizationPosition);
        if (rows < 0) {
            throw new DaoException("update org_organization_position error");
        }
        Group activitiGroup = (Group)this.identityService.createGroupQuery().groupId(String.valueOf(organizationPosition.getId())).singleResult();
        if (activitiGroup != null) {
            this.identityService.deleteGroup(String.valueOf(organizationPosition.getId()));
        }
        return true;
    }

    private boolean batchInsertPositionEmployee(List<String> employeeIds, OrganizationPosition organizationPosition) {
        if (employeeIds == null || employeeIds.size() == 0) {
            return true;
        }
        ShiroUser user = ShiroUtil.getUser();
        long loginUserId = user.getId();
        Integer dateNow = DateUtil.unixTime();
        ArrayList positionEmployees = Lists.newArrayList();
        for (String id : employeeIds) {
            PositionEmployee positionEmployee = new PositionEmployee();
            positionEmployee.setDeleteFlag(0);
            positionEmployee.setCreateTime(dateNow);
            positionEmployee.setUpdateTime(dateNow);
            positionEmployee.setCreater(loginUserId);
            positionEmployee.setUpdater(loginUserId);
            positionEmployee.setDateline(dateNow);
            positionEmployee.setOrgId(organizationPosition.getOrgId());
            positionEmployee.setPositionId(organizationPosition.getPositionId());
            positionEmployee.setOrgPositionId(organizationPosition.getId());
            positionEmployee.setEmployeeId(Long.valueOf(id));
            positionEmployees.add(positionEmployee);
        }
        boolean res = this.positionEmployeeService.insertBatch(positionEmployees);
        if (res) {
            for (String id : employeeIds) {
                Employee employee = (Employee)((Object)this.employeeService.selectById(Long.valueOf(id)));
                User activitiUser = (User)this.identityService.createUserQuery().userId(String.valueOf(id)).singleResult();
                if (activitiUser == null) {
                    activitiUser = this.identityService.newUser(String.valueOf(employee.getId()));
                    activitiUser.setFirstName(String.valueOf(employee.getId()));
                    activitiUser.setLastName(employee.getUsername());
                    this.identityService.saveUser(activitiUser);
                }
                this.identityService.createMembership(id, String.valueOf(organizationPosition.getId()));
            }
        }
        return res;
    }

    private boolean batchDeletePositionEmployee(long orgPositionId) {
        OrganizationPosition organizationPosition = (OrganizationPosition)((Object)((OrganizationPositionMapper)this.baseMapper).selectById(Long.valueOf(orgPositionId)));
        if (organizationPosition.getMemberSize() != null && organizationPosition.getMemberSize() > 0) {
            PositionEmployee positionEmployee = new PositionEmployee();
            positionEmployee.setDeleteFlag(1);
            positionEmployee.setOrgPositionId(orgPositionId);
            Wrapper condition = Condition.create().eq("org_position_id", (Object)orgPositionId);
            boolean res = this.positionEmployeeService.update((Object)positionEmployee, condition);
            if (res) {
                List users = this.identityService.createUserQuery().memberOfGroup(String.valueOf(orgPositionId)).list();
                for (User user : users) {
                    this.identityService.deleteMembership(user.getId(), String.valueOf(orgPositionId));
                }
            }
            return res;
        }
        return true;
    }
}

