/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.user.service.impl;

import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.vo.ZTreeVO;
import com.jtech.toa.user.dao.PositionMapper;
import com.jtech.toa.user.domain.Position;
import com.jtech.toa.user.model.vo.PositionVO;
import com.jtech.toa.user.service.IPositionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.cache.annotation.CachePut;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class PositionServiceImpl
extends ServiceImpl<PositionMapper, Position>
implements IPositionService {
    private static List<ZTreeVO<Position>> listToZtree(List<Position> positions) {
        int positionSize = positions.size();
        ArrayList zTreeVOList = Lists.newArrayListWithCapacity((int)positionSize);
        for (Position position : positions) {
            ZTreeVO zTreeVO = ZTreeVO.builder().data((Serializable)((Object)position)).id(position.getId()).pid(position.getParentId()).name(position.getName()).build();
            zTreeVOList.add(zTreeVO);
        }
        return zTreeVOList;
    }

    @Override
    @Transactional(readOnly=true)
    public Position selectById(long id) {
        return (Position)((Object)((PositionMapper)this.baseMapper).selectById(Long.valueOf(id)));
    }

    @Override
    public boolean stopUsePosition(long id) {
        Position position = new Position();
        position.setId(id);
        position.setAdminFlag(0);
        int rows = ((PositionMapper)this.baseMapper).updateById((Object)position);
        if (rows < 0) {
            throw new DaoException("\u7981\u7528\u804c\u4f4d\u5931\u8d25");
        }
        return true;
    }

    @Override
    @CachePut(value={"form-position-cache"})
    public boolean usePosition(long id) {
        Position position = new Position();
        position.setId(id);
        position.setAdminFlag(1);
        int rows = ((PositionMapper)this.baseMapper).updateById((Object)position);
        if (rows < 0) {
            throw new DaoException("\u804c\u4f4d\u542f\u52a8\u5931\u8d25");
        }
        return true;
    }

    @Override
    @CachePut(value={"form-position-cache"})
    public boolean deletePosition(long id) {
        Position position = new Position();
        position.setId(id);
        position.setDeleteFlag(true);
        int rows = ((PositionMapper)this.baseMapper).updateById((Object)position);
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ZTreeVO<Position>> findAllToTree(String likeName) {
        if (Strings.isNullOrEmpty((String)likeName)) {
            return this.generateOrgTree();
        }
        return this.generateOrgTreeByName(likeName);
    }

    private List<ZTreeVO<Position>> generateOrgTree() {
        List<Position> positions = ((PositionMapper)this.baseMapper).findAll();
        if (CollectionUtil.isEmpty(positions)) {
            return Collections.emptyList();
        }
        return PositionServiceImpl.listToZtree(positions);
    }

    private List<ZTreeVO<Position>> generateOrgTreeByName(String name) {
        List positions = this.selectList(Condition.create().like("name", name));
        if (CollectionUtil.isEmpty((Collection)positions)) {
            return Collections.emptyList();
        }
        return PositionServiceImpl.listToZtree(positions);
    }

    @Override
    @Transactional
    @CachePut(value={"form-position-cache"})
    public boolean insertPosition(Position position) {
        position.setCreateTime(DateUtil.unixTime());
        position.setUpdateTime(DateUtil.unixTime());
        long parentId = position.getParentId();
        position.setLevel(this.getLevel(parentId));
        position.setDeleteFlag(false);
        position.setAdminFlag(1);
        try {
            position.setDomain(PinyinHelper.convertToPinyinString((String)position.getName(), (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE));
        }
        catch (PinyinException e) {
            e.printStackTrace();
        }
        int rows = ((PositionMapper)this.baseMapper).insert((Object)position);
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    @CachePut(value={"form-position-cache"})
    public boolean updatePosition(Position position) {
        position.setUpdateTime(DateUtil.unixTime());
        long parentId = position.getParentId();
        position.setLevel(this.getLevel(parentId));
        try {
            position.setDomain(PinyinHelper.convertToPinyinString((String)position.getName(), (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE));
        }
        catch (PinyinException e) {
            e.printStackTrace();
        }
        int rows = ((PositionMapper)this.baseMapper).updateById((Object)position);
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    private Long getLevel(long parentId) {
        if (parentId != 0L) {
            Position parentPosition = this.selectById(parentId);
            if (parentPosition != null) {
                return parentPosition.getLevel() + 1L;
            }
            return 1L;
        }
        return 1L;
    }

    @Override
    @Transactional(readOnly=true)
    public List<PositionVO> findAllWithForm() {
        List<Position> positions = ((PositionMapper)this.baseMapper).findAll();
        if (CollectionUtil.isEmpty(positions)) {
            return Collections.emptyList();
        }
        ArrayList positionVOS = Lists.newArrayListWithCapacity((int)positions.size());
        for (Position position : positions) {
            PositionVO positionVO = new PositionVO();
            positionVO.setCode(position.getCode());
            positionVO.setName(position.getName());
            positionVO.setId(position.getId());
            positionVO.setPrarentId(position.getParentId());
            positionVOS.add(positionVO);
        }
        return positionVOS;
    }
}

