/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.bpm.facde;

import com.google.common.collect.Maps;

import com.jingtong.bpm.facde.dto.BaseProcessDTO;
import com.jingtong.bpm.facde.dto.ProcessGridDTO;
import com.jingtong.bpm.facde.dto.ProcessTypeDTO;
import com.jingtong.data.rest.R;

import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * <p> </p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@RequiredArgsConstructor
@Service
@Slf4j
public class ProcessFLowHttpClient extends BaseHttpClient {
    private final OkHttpUtil okHttpUtil;

    public R<List<ProcessTypeDTO>> types(String user) {
        Map<String, Object> params = Maps.newHashMap();
        final R<List<ProcessTypeDTO>> objectR = okHttpUtil.getList(this.host + processUrl + "/type", params, user);
        return objectR;
    }

    public R<List<ProcessTypeDTO>> processTypes(String name, String user) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("name", name);
        final R<List<ProcessTypeDTO>> objectR = okHttpUtil.getList(this.host + processUrl + "/list/type", params, user);
        return objectR;
    }

    public R<List<ProcessGridDTO>> grid(
            Map<String, Object> params, String user
    ) {
        final R<List<ProcessGridDTO>> listR = okHttpUtil.getList(this.host + processUrl + "/list", params, user);
        return listR;
    }

    public R save(BaseProcessDTO process, String user) {
        final R listR = okHttpUtil.post(this.host + processUrl + "/save", process, user);
        return listR;
    }

    /**
     * 删除流程
     *
     * @param processId 流程
     * @return 删除结果
     */
    public R remove(long processId, String user) {
        final R listR = okHttpUtil.delete(this.host + processUrl + "/" + processId, user);
        return listR;
    }

    /**
     * 撤回流程
     *
     * @param processId 流程
     * @return 撤回结果
     */
    public R cancel(long processId, String user) {
        final R listR = okHttpUtil.put(this.host + processUrl + "/cancel/" + processId, user);
        return listR;
    }

    /**
     * 启用流程
     *
     * @param processId 流程
     * @return 启动结果
     */
    public R enable(long processId, String user) {
        final R listR = okHttpUtil.put(this.host + processUrl + "/enable/" + processId, user);
        return listR;
    }

    /**
     * 禁用流程
     *
     * @param processId 流程
     * @return 禁用结果
     */
    public R disable(long processId, String user) {
        final R listR = okHttpUtil.put(this.host + processUrl + "/disable/" + processId, user);
        return listR;
    }

    /**
     * 发布流程
     *
     * @param processId 流程ID
     * @return 发布是否成功
     */
    public R release(
            long processId, String user
    ) {
        final R listR = okHttpUtil.put(this.host + processUrl + "/release/" + processId, user);
        return listR;
    }


    /**
     * 开始使用流程
     *
     * @param processId 流程主键
     * @return 操作响应
     */
    public R open(
            long processId, String user
    ) {
        final R listR = okHttpUtil.put(this.host + processUrl + "/open/" + processId, user);
        return listR;
    }

    /**
     * 关闭流程
     *
     * @param processId 流程主键
     * @return 操作响应
     */
    public R closed(long processId, String user) {
        final R listR = okHttpUtil.put(this.host + processUrl + "/closed/" + processId, user);
        return listR;
    }

    public R<BaseProcessDTO> info(long processId, String user) {
        Map<String, Object> params = Maps.newConcurrentMap();
        params.put("id", processId);
        final R<BaseProcessDTO> oneR = okHttpUtil.getOne(this.host + processUrl + "/info", params, user);
        return oneR;
    }

    public R<String> printTmp(long processId,String user){
        Map<String, Object> params = Maps.newConcurrentMap();
        params.put("id", processId);
        final R<String> oneR = okHttpUtil.getOne(this.host + processUrl + "/print/tmp", params, user);
        return oneR;
    }
}
