/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.bpm.facde;

import com.google.common.collect.Maps;

import com.alibaba.fastjson.JSONObject;
import com.jingtong.bpm.facde.dto.BillItemDTO;
import com.jingtong.bpm.facde.dto.BillTaskDTO;
import com.jingtong.data.rest.R;
import com.jingtong.util.bean.BeanUtil;

import java.util.List;
import java.util.Map;

import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * <p> </p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@Slf4j
public class BillHttpClient extends BaseHttpClient {
    private final OkHttpUtil okHttpUtil;

    public BillHttpClient(OkHttpUtil okHttpUtil, String host) {
        this.okHttpUtil = okHttpUtil;
        if (host.endsWith(StrUtil.C_SLASH + "")) {
            host = host.substring(0, host.length() - 1);
        }
        this.host = host;
    }

    public R<List<BillItemDTO>> minecreate(Map<String, Object> params, String user) {
        final R<List<BillItemDTO>> objectR = okHttpUtil.getList(this.host + ListUrl + "/minecreate", params, user);
        return objectR;
    }

    public R<List<BillItemDTO>> approved(Map<String, Object> params, String user) {
        final R<List<BillItemDTO>> objectR = okHttpUtil.getList(this.host + ListUrl + "/approved", params, user);
        return objectR;
    }

    public R<List<BillItemDTO>> todo(Map<String, Object> params, String user) {
        final R<List<BillItemDTO>> objectR = okHttpUtil.getList(this.host + ListUrl + "/todo", params, user);
        return objectR;
    }

    public R<String> todoSize(String user) {
        Map<String, Object> params = Maps.newHashMap();
        final R<String> objectR = okHttpUtil.getOne(this.host + ListUrl + "/todo/size", params, user);
        return objectR;
    }

    public R<List<BillItemDTO>> drafts(Map<String, Object> params, String user) {
        final R<List<BillItemDTO>> objectR = okHttpUtil.getList(this.host + ListUrl + "/drafts", params, user);
        return objectR;
    }

    public R<List<BillItemDTO>> cc(Map<String, Object> params, String user) {
        final R<List<BillItemDTO>> objectR = okHttpUtil.getList(this.host + ListUrl + "/cc", params, user);
        return objectR;
    }

    public R<List<BillItemDTO>> findAll(Map<String, Object> params, String user) {
        final R<List<BillItemDTO>> objectR = okHttpUtil.getList(this.host + ListUrl + "/all/bill", params, user);
        return objectR;
    }

    public R<BillItemDTO> submit(JSONObject data, String user) {
        final R<JSONObject> objectR = okHttpUtil.postReturnOne(this.host + thirdPartUrl + "/submit", data, user);
        BillItemDTO data1 = BeanUtil.toBean(objectR.getData(), BillItemDTO.class);
        return R.ok(data1);
    }

    public R<BillItemDTO> saveDrafts(JSONObject data, String user) {
        final R<JSONObject> objectR = okHttpUtil.postReturnOne(this.host + thirdPartUrl + "/save", data, user);
        BillItemDTO data1 = BeanUtil.toBean(objectR.getData(), BillItemDTO.class);
        return R.ok(data1);
    }

    public R<List<BillTaskDTO>> getHistoryTasks(String billId, String user) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("billId", billId);
        final R<List<BillTaskDTO>> result = okHttpUtil.getList(this.host + ListUrl + "/history/tasks", params, user);
        return result;
    }

}
