/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facde;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Strings;
import com.jingtong.data.rest.R;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OkHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtil.class);
    private static OkHttpClient okHttpClient;
    static final MediaType JSON_TYPE;

    public X509TrustManager x509TrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public SSLSocketFactory sslSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.x509TrustManager()}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ConnectionPool pool() {
        return new ConnectionPool(200, 5L, TimeUnit.MINUTES);
    }

    public OkHttpClient getHttpClient() {
        if (null == okHttpClient) {
            okHttpClient = new OkHttpClient.Builder().sslSocketFactory(this.sslSocketFactory(), this.x509TrustManager()).addNetworkInterceptor((Interceptor)new OkHttpNetInterceptor()).retryOnConnectionFailure(false).connectionPool(this.pool()).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
            return okHttpClient;
        }
        return okHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R put(String url, String user) {
        Request request = new Request.Builder().url(url).addHeader("Authorization", user).put(Util.EMPTY_REQUEST).build();
        try (Response response = null;){
            response = this.getHttpClient().newCall(request).execute();
            if (response.isSuccessful()) {
                R r = R.ok();
                return r;
            }
            R r = R.state((boolean)false);
            return r;
        }
        return R.state((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R delete(String url, String user) {
        Request request = new Request.Builder().url(url).addHeader("Authorization", user).delete().build();
        try (Response response = null;){
            response = this.getHttpClient().newCall(request).execute();
            if (response.isSuccessful()) {
                R r = R.ok();
                return r;
            }
            R r = R.state((boolean)false);
            return r;
        }
        return R.state((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> R<List<E>> post(String url, Object requestBody, String user) {
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)JSON.toJSONString((Object)requestBody));
        Request request = new Request.Builder().url(url).addHeader("Authorization", user).post(body).build();
        try (Response response = null;){
            response = this.getHttpClient().newCall(request).execute();
            if (response.isSuccessful()) {
                R r;
                String result = response.body().string();
                R r2 = r = (R)JSON.parseObject((String)result, R.class);
                return r2;
            }
        }
        return R.state((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> R<E> postReturnOne(String url, Object requestBody, String user) {
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)JSON.toJSONString((Object)requestBody));
        Request request = new Request.Builder().url(url).addHeader("Authorization", user).post(body).build();
        try (Response response = null;){
            response = this.getHttpClient().newCall(request).execute();
            if (response.isSuccessful()) {
                R r;
                String result = response.body().string();
                R r2 = r = (R)JSON.parseObject((String)result, R.class);
                return r2;
            }
        }
        return R.state((boolean)false);
    }

    public <T> R<List<T>> getList(String url, Map<String, Object> params, String user) {
        String reposeStr = this.get(url, params, user);
        if (Strings.isNullOrEmpty((String)reposeStr)) {
            return R.ok(Collections.emptyList());
        }
        R r = (R)JSON.parseObject((String)reposeStr, R.class);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String url, Map<String, Object> params, String user) {
        Request.Builder reqBuild = new Request.Builder();
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        for (String s : params.keySet()) {
            if (Objects.isNull(params.get(s))) continue;
            try {
                urlBuilder.addQueryParameter(s, URLEncoder.encode(params.get(s).toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        reqBuild.url(urlBuilder.build());
        reqBuild.addHeader("Authorization", user);
        Request request = reqBuild.build();
        try (Response response = null;){
            response = this.getHttpClient().newCall(request).execute();
            if (response.isSuccessful()) {
                String result;
                String string = result = response.body().string();
                return string;
            }
        }
        return "";
    }

    public <T> R<T> getOne(String url, Map<String, Object> params, String user) {
        String resposeStr = this.get(url, params, user);
        if (Strings.isNullOrEmpty((String)resposeStr)) {
            return R.ok();
        }
        R r = (R)JSON.parseObject((String)resposeStr, (TypeReference)new TypeReference<R<T>>(){}, (Feature[])new Feature[0]);
        return r;
    }

    static {
        JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    }

    class OkHttpNetInterceptor
    implements Interceptor {
        OkHttpNetInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request().newBuilder().addHeader("Connection", "close").build();
            return chain.proceed(request);
        }
    }
}

