/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facde;

import com.google.common.collect.Maps;
import com.jingtong.bpm.facde.BaseHttpClient;
import com.jingtong.bpm.facde.OkHttpUtil;
import com.jingtong.bpm.facde.dto.BaseProcessDTO;
import com.jingtong.bpm.facde.dto.ProcessGridDTO;
import com.jingtong.bpm.facde.dto.ProcessTypeDTO;
import com.jingtong.data.rest.R;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessFLowHttpClient
extends BaseHttpClient {
    private static final Logger log = LoggerFactory.getLogger(ProcessFLowHttpClient.class);
    private final OkHttpUtil okHttpUtil;

    public ProcessFLowHttpClient(OkHttpUtil okHttpUtil, String host) {
        this.okHttpUtil = okHttpUtil;
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        this.host = host;
    }

    public R<List<ProcessTypeDTO>> types(String user) {
        HashMap params = Maps.newHashMap();
        R objectR = this.okHttpUtil.getList(this.host + processUrl + "/type", params, user);
        return objectR;
    }

    public R<List<ProcessTypeDTO>> processTypes(String name, String user) {
        HashMap params = Maps.newHashMap();
        params.put("name", name);
        R objectR = this.okHttpUtil.getList(this.host + processUrl + "/list/type", params, user);
        return objectR;
    }

    public R<List<ProcessGridDTO>> grid(Map<String, Object> params, String user) {
        R listR = this.okHttpUtil.getList(this.host + processUrl + "/list", params, user);
        return listR;
    }

    public R save(BaseProcessDTO process, String user) {
        R listR = this.okHttpUtil.post(this.host + processUrl + "/save", process, user);
        return listR;
    }

    public R remove(long processId, String user) {
        R listR = this.okHttpUtil.delete(this.host + processUrl + "/" + processId, user);
        return listR;
    }

    public R cancel(long processId, String user) {
        R listR = this.okHttpUtil.put(this.host + processUrl + "/cancel/" + processId, user);
        return listR;
    }

    public R enable(long processId, String user) {
        R listR = this.okHttpUtil.put(this.host + processUrl + "/enable/" + processId, user);
        return listR;
    }

    public R disable(long processId, String user) {
        R listR = this.okHttpUtil.put(this.host + processUrl + "/disable/" + processId, user);
        return listR;
    }

    public R release(long processId, String user) {
        R listR = this.okHttpUtil.put(this.host + processUrl + "/release/" + processId, user);
        return listR;
    }

    public R open(long processId, String user) {
        R listR = this.okHttpUtil.put(this.host + processUrl + "/open/" + processId, user);
        return listR;
    }

    public R closed(long processId, String user) {
        R listR = this.okHttpUtil.put(this.host + processUrl + "/closed/" + processId, user);
        return listR;
    }

    public R<BaseProcessDTO> info(long processId, String user) {
        ConcurrentMap params = Maps.newConcurrentMap();
        params.put("id", processId);
        R oneR = this.okHttpUtil.getOne(this.host + processUrl + "/info", params, user);
        return oneR;
    }

    public R<String> printTmp(long processId, String user) {
        ConcurrentMap params = Maps.newConcurrentMap();
        params.put("id", processId);
        R oneR = this.okHttpUtil.getOne(this.host + processUrl + "/print/tmp", params, user);
        return oneR;
    }
}

