package com.jingtong.bpm.infra.service;

import java.util.List;

import com.jingtong.bpm.infra.entity.ProcessNodeApproverEntity;
import com.jingtong.base.infra.service.BaseService;

/**
 * <p>
 * 节点审批人 服务类
 * </p>
 *
 * @author JT
 * @since 2021-03-23
 */
public interface ProcessNodeApproverService extends BaseService<ProcessNodeApproverEntity> {

    /**
     * 保存节点审批人配置
     *
     * @param nodeApprovers 审批人配置
     * @param processId     业务流程主键
     */
    void saveOrUpdate(List<ProcessNodeApproverEntity> nodeApprovers, long processId);

    /**
     * 根据流程标记和节点 取得节点的审批人配置
     *
     * @param flowId 流程标记
     * @param nodeId        节点ID
     * @return 审批人配置
     */
    List<ProcessNodeApproverEntity> findByFlowIdAndNodeId(String flowId, String nodeId);
}
