package com.jingtong.bpm.infra.service.impl;

import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.bpm.infra.dao.ProcessBillTitleDao;
import com.jingtong.bpm.infra.entity.ProcessBillTitleEntity;
import com.jingtong.bpm.infra.po.BillTitlePO;
import com.jingtong.bpm.infra.service.ProcessBillTitleService;

import org.springframework.stereotype.Service;

/**
 * <p>
 * 流程标题规则 服务实现类
 * </p>
 *
 * @author JT
 * @since 2021-03-23
 */
@Service
public class ProcessBillTitleServiceImpl extends BaseServiceImpl<ProcessBillTitleDao, ProcessBillTitleEntity> implements ProcessBillTitleService {

    /**
     * 根据流程取得标题信息
     *
     * @param processId 流程主键
     * @return 标题信息
     */
    @Override
    public BillTitlePO findByProcessId(long processId) {
        return this.baseMapper.selectByProcessId(processId);
    }
}
