/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.bpm.logic.converts;

import com.jingtong.bpm.facde.dto.DatasourceDTO;
import com.jingtong.bpm.infra.entity.DatasourceComboEntity;
import com.jingtong.bpm.infra.entity.DatasourceConditionsEntity;
import com.jingtong.bpm.infra.entity.DatasourceFiledEntity;
import com.jingtong.bpm.infra.entity.DatasourcePopoverEntity;
import com.jingtong.bpm.infra.entity.ToaDatasourceEntity;
import com.jingtong.bpm.infra.po.TableFieldPO;
import com.jingtong.bpm.logic.dto.DatasourceComboDTO;
import com.jingtong.bpm.logic.dto.DatasourceConditionDTO;
import com.jingtong.bpm.logic.dto.DatasourceFiledDTO;
import com.jingtong.bpm.logic.dto.DatasourcePopoverDTO;
import com.jingtong.bpm.logic.dto.ZZTableField;

import org.mapstruct.Mapper;

import java.util.List;

/**
 * <p> </p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@Mapper(componentModel = "spring")
public interface DataSourceBasicConvert {

    DatasourceDTO datasourceEntityToDTO(ToaDatasourceEntity datasourceEntity);

    List<DatasourceDTO> datasourcesEntityToDTO(List<ToaDatasourceEntity> records);

    DatasourcePopoverDTO datasourcePopoverEntityToDTO(DatasourcePopoverEntity datasourcePopoverEntity);

    DatasourceComboDTO datasourceComboEntityToDTO(DatasourceComboEntity datasourceComboEntity);

    List<DatasourceConditionDTO> datasourceConditionsEntityToDTO(List<DatasourceConditionsEntity> conditionsEntities);

    ToaDatasourceEntity datasourceDTOToEntity(DatasourceDTO dto);

    List<DatasourceFiledEntity> datasourceFiledDTOToEntity(List<DatasourceFiledDTO> datasourceFiledDTOS);

    List<DatasourceConditionsEntity> datasourceConditionDTOToEntity(List<DatasourceConditionDTO> conditions);

    DatasourceComboEntity datasourceComboDTOToEntity(DatasourceComboDTO combo);

    DatasourcePopoverEntity datasourcePopoverDTOToEntity(DatasourcePopoverDTO popover);

    List<ZZTableField> tableFieldPOToField(List<TableFieldPO> fieldPOS);

}
