/*
 * Copyright (c)2012-2017 JingTong RDC(Research and Development Centre), Inc. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of JingTong RDC ,
 *         if any. The intellectual and technical concepts contained herein are proprietary
 *         to JingTong RDC and covered by China and Foreign Patents, patents in process,
 *         and are protected by trade secret or copyright law. Dissemination of this information
 *         or reproduction of this material is strictly forbidden unless prior written permission
 *         is obtained from JingTong RDC.
 */

package com.jingtong.bpm.logic.listener;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;

import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.config.SpringContextHolder;

import org.activiti.engine.delegate.BaseExecutionListener;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

import lombok.extern.slf4j.Slf4j;

/**
 * <p> 整个流程实例的监听器 </p>
 *
 * @author sog
 * @version 1.0
 * @since JDK 1.7
 */
@Slf4j
public class ProcessBillListener implements ExecutionListener {
    private static final long serialVersionUID = 1720995327038825119L;

    @Override
    public void notify(DelegateExecution execution) {
        log.debug("进入了ProcessBillListener");
        String eventName = execution.getEventName();
        if (StringUtils.equals(eventName, BaseExecutionListener.EVENTNAME_END)) {
            // 结束事件
            final Object varAction = ((ExecutionEntityImpl) execution).getProcessInstance().getVariable("var_action");

            final String action = Objects.isNull(varAction) ? "" : (String) varAction;
            final String businessKey = execution.getProcessInstanceBusinessKey();
            // 更新审批单为结束
            if (StringUtils.isNotEmpty(businessKey)) {
                long billId = MoreObjects.firstNonNull(Longs.tryParse(businessKey), 0L);
                if (billId > 0) {
                    final BillLogic billService = SpringContextHolder.getBean(BillLogic.class);
                    billService.complete(billId, action);
                }
            }
        }
    }
}
