/*
 * Copyright (c)2012-2017 JingTong RDC(Research and Development Centre), Inc. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of JingTong RDC ,
 *         if any. The intellectual and technical concepts contained herein are proprietary
 *         to JingTong RDC and covered by China and Foreign Patents, patents in process,
 *         and are protected by trade secret or copyright law. Dissemination of this information
 *         or reproduction of this material is strictly forbidden unless prior written permission
 *         is obtained from JingTong RDC.
 */

package com.jingtong.bpm.logic.query.list;


import lombok.Data;
import lombok.EqualsAndHashCode;
import com.jingtong.bpm.logic.constant.StringPool;

/**
 * <p> 审批单 我发起的查询条件</p>
 *
 * @author sog
 * @version 1.0
 * @since JDK 1.7
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CcBillQuery extends DraftBillQuery {
    private static final long serialVersionUID = 5387143641375409300L;
    private long approval;
    private String title;


    @Override
    public String getTitleLike() {
        if (this.title == null) {
            this.title = StringPool.EMPTY;
        }
        return StringPool.PERCENT + title + StringPool
                .PERCENT;
    }
    private long sender;

}
