/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.bpm.facade.rest;

import com.google.common.base.Strings;

import com.jingtong.bpm.logic.dto.ZTreeDTO;
import com.jingtong.bpm.logic.service.UserCenterlogic;
import com.jingtong.data.rest.R;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import lombok.RequiredArgsConstructor;

/**
 * <p> </p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/process/tree/rest")
public class ProcessTreeRestController {
    private final UserCenterlogic  userCenterlogic;

    @GetMapping("/organization")
    public R organization(String q) {
        final List<ZTreeDTO> organization = userCenterlogic.organization("",Strings.isNullOrEmpty(q) ? "" : q);
        return R.ok(organization);
    }

    @GetMapping("/organization/user")
    public R organizationUser(String q,
                              @RequestParam(value = "onlyChoiceUser", required = false) boolean onlyChoiceUser) {
        return R.ok(userCenterlogic.organizationUser("",q, onlyChoiceUser));
    }


    @GetMapping("/position/user")
    public R positionUser() {
        return R.ok(userCenterlogic.positionUser(""));
    }

    @GetMapping("/position")
    public R position(String q) {
        return R.ok(userCenterlogic.position("",Strings.isNullOrEmpty(q) ? "" : q));
    }
}
