/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.bpm.infra.service;

/**
 * <p> </p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
public interface SerialNumberLogic {
    /**
     * 根据流水号前缀获取当前流水
     *
     * @param prefix 缓存前缀KEY
     * @param digits 流水号位数
     * @return 流水号
     */
    String serialNumber(String prefix, int digits);


    /**
     * 获取每日轮询的当前流水号
     *
     * @param prefix 缓存前缀KEY
     * @param digits 流水号位数
     * @return 流水号
     */
    String dayPolling(String prefix, int digits);
}
