package com.jingtong.bpm.infra.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jingtong.bpm.infra.dao.ProcessDesingerDao;
import com.jingtong.bpm.infra.entity.ProcessDesingerEntity;
import com.jingtong.bpm.infra.service.ProcessDesingerService;
import com.jingtong.bpm.logic.vo.ProcessDesingerVO;
import com.jingtong.base.infra.service.impl.BaseServiceImpl;
import com.jingtong.data.exception.RbException;

import org.springframework.stereotype.Service;

import static com.jingtong.bpm.logic.error.BillCode.PROCESS_DESIGN_SAVE_ERROR;

/**
 * <p>
 * 流程设计信息 服务实现类
 * </p>
 *
 * @author JT
 * @since 2021-03-23
 */
@Service
public class ProcessDesingerServiceImpl extends BaseServiceImpl<ProcessDesingerDao, ProcessDesingerEntity> implements ProcessDesingerService {

    @Override
    public void saveOrUpdateByProcess(long processId, String processDesingerJSON, ProcessDesingerVO processDesingerVO) {
        ProcessDesingerEntity desinger = this.getOne(Wrappers.lambdaQuery(ProcessDesingerEntity.class).eq(ProcessDesingerEntity::getProcessId, processId));
        if (desinger == null) {
            desinger = new ProcessDesingerEntity();
            desinger.setProcessId(processId);
            desinger.setProcessXml(processDesingerVO.getXml());
            desinger.setDesingerJson(processDesingerJSON);
            final boolean desingerSaveState = this.insert(desinger);
            if (!desingerSaveState) {
                throw new RbException(PROCESS_DESIGN_SAVE_ERROR);
            }
        } else {
            desinger.setProcessXml(processDesingerVO.getXml());
            desinger.setDesingerJson(processDesingerJSON);
            final boolean desingerUpdateState = this.updateById(desinger);
            if (!desingerUpdateState) {
                throw new RbException(PROCESS_DESIGN_SAVE_ERROR);
            }
        }
    }
}
