/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.bpm.logic.converts;

import com.jingtong.bpm.facde.dto.BaseProcessDTO;
import com.jingtong.bpm.facde.dto.ProcessDTO;
import com.jingtong.bpm.facde.dto.ProcessGridDTO;
import com.jingtong.bpm.facde.dto.ProcessTypeDTO;
import com.jingtong.bpm.infra.entity.ProcessDesingerEntity;
import com.jingtong.bpm.infra.entity.ProcessTypeEntity;
import com.jingtong.bpm.infra.entity.ToaProcessEntity;
import com.jingtong.bpm.infra.po.ProcessGridPO;
import com.jingtong.bpm.logic.dto.ProcessDesingerDTO;
import com.jingtong.bpm.logic.dto.ProcessDetailDTO;
import com.jingtong.bpm.logic.vo.ProcessTypeVO;
import com.jingtong.bpm.logic.vo.ProcessVO;

import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

/**
 * <p> </p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@Mapper(componentModel = "spring")
public interface ProcessBasicConvert {

    List<ProcessDTO> processVOtoDTO(List<ProcessVO> flows);

    ProcessDetailDTO processDetailEntityToDTO(ToaProcessEntity processEntity);

    ProcessDesingerDTO processDesingerEntityToDTO(ProcessDesingerEntity desingerEntity);

    ProcessTypeDTO processTypeVOToDTO(ProcessTypeVO processType);

    ProcessTypeEntity processTypeDTOToEntity(com.jingtong.bpm.logic.dto.ProcessTypeDTO processTypeDTO);

    List<com.jingtong.bpm.logic.dto.ProcessTypeDTO> processTypesEntityToDTO(List<ProcessTypeEntity> processType);

    com.jingtong.bpm.logic.dto.ProcessTypeDTO processTypeEntityToDTO(ProcessTypeEntity processType);

    List<ProcessGridDTO> processGridPOToDTO(List<ProcessGridPO> list);

    ToaProcessEntity baseProcessDTOToEntity(BaseProcessDTO baseProcessDTO);


    @Mapping(source = "displayName",target = "name")
    ProcessVO processGridPOToProcessVO(ProcessGridPO processGridPO);

    List<ProcessVO> processGridPOToVO(List<ProcessGridPO> processGridPOS);

    List<com.jingtong.bpm.facde.dto.ProcessTypeDTO> processTypeEntityToDTO(List<ProcessTypeEntity> processTypeEntities);

    BaseProcessDTO processEntityToDTO(ToaProcessEntity byId);

}
