/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.feign;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.jingtong.bpm.facde.dto.BillItemDTO;
import com.jingtong.bpm.facde.dto.BillTaskDTO;
import com.jingtong.bpm.logic.converts.BillBasicConvert;
import com.jingtong.bpm.logic.query.list.ApprovedBillQuery;
import com.jingtong.bpm.logic.query.list.CcBillQuery;
import com.jingtong.bpm.logic.query.list.DraftBillQuery;
import com.jingtong.bpm.logic.query.list.MeCreateBillQuery;
import com.jingtong.bpm.logic.query.list.TodoBillQuery;
import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.bpm.logic.service.BillTaskLogic;
import com.jingtong.bpm.logic.vo.BillItemVO;
import com.jingtong.bpm.logic.vo.BillTaskVO;
import com.jingtong.data.rest.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/bill/list/feign"})
@RestController
@Api(tags={"\u5ba1\u6279\u5355\u5217\u8868"})
public class BillListFeignController {
    private final BillLogic billLogic;
    private final BillTaskLogic billTaskLogic;
    private final BillBasicConvert billBasicConvert;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6211\u5df2\u5ba1\u6279\u7684\u5ba1\u6279\u5355", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"approved"})
    public R<List<BillItemDTO>> approved(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String q = (String)params.get("q");
        String filterText = this.decode(q);
        ApprovedBillQuery query = !Strings.isNullOrEmpty((String)filterText) ? (ApprovedBillQuery)JSON.parseObject((String)filterText, ApprovedBillQuery.class) : new ApprovedBillQuery();
        Pair<List<BillItemVO>, Long> result = this.billLogic.findApproved(pageNo, pageSize, query);
        List key = (List)result.getKey();
        return R.ok(this.billBasicConvert.billItemsVOToDTO(key), (Long)((Long)result.getValue()));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f85\u6211\u5ba1\u6279\u7684\u5ba1\u6279\u5355", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"/todo"})
    public R<List<BillItemDTO>> todo(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String q = (String)params.get("q");
        String filterText = this.decode(q);
        TodoBillQuery query = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            query = (TodoBillQuery)JSON.parseObject((String)filterText, TodoBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findTodo(pageNo, pageSize, query);
        List key = (List)result.getKey();
        return R.ok(this.billBasicConvert.billItemsVOToDTO(key), (Long)((Long)result.getValue()));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6211\u53d1\u8d77\u7684\u5ba1\u6279", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"/minecreate"})
    public R<List<BillItemDTO>> sended(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String q = (String)params.get("q");
        String filterText = this.decode(q);
        MeCreateBillQuery billQuery = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            billQuery = (MeCreateBillQuery)JSON.parseObject((String)filterText, MeCreateBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findMeCreate(pageNo, pageSize, billQuery);
        List key = (List)result.getKey();
        return R.ok(this.billBasicConvert.billItemsVOToDTO(key), (Long)((Long)result.getValue()));
    }

    @GetMapping(value={"/drafts"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6211\u7684\u8349\u7a3f\u5ba1\u6279", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    public R<List<BillItemDTO>> drafts(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String q = (String)params.get("q");
        String filterText = this.decode(q);
        DraftBillQuery query = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            query = (DraftBillQuery)JSON.parseObject((String)filterText, DraftBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findDraft(pageNo, pageSize, query);
        List key = (List)result.getKey();
        return R.ok(this.billBasicConvert.billItemsVOToDTO(key), (Long)((Long)result.getValue()));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6284\u9001\u6211\u7684\u5ba1\u6279", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"/cc"})
    public R<List<BillItemDTO>> cc(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String q = (String)params.get("q");
        String filterText = this.decode(q);
        CcBillQuery query = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            query = (CcBillQuery)JSON.parseObject((String)filterText, CcBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findCc(pageNo, pageSize, query);
        List key = (List)result.getKey();
        return R.ok(this.billBasicConvert.billItemsVOToDTO(key), (Long)((Long)result.getValue()));
    }

    private String decode(String q) {
        String filterText = "";
        try {
            filterText = URLDecoder.decode(Strings.isNullOrEmpty((String)q) ? "" : q, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return filterText;
    }

    @GetMapping(value={"/todo/size"})
    public R<String> todoSize() {
        String todoSize = this.billLogic.findTodoSize();
        return R.ok((Object)todoSize);
    }

    @GetMapping(value={"/history/tasks"})
    public R<List<BillTaskDTO>> getHistoryTasks(Long billId) {
        List<BillTaskVO> billTaskVOS = this.billTaskLogic.getHistoryTasks(billId);
        return R.ok(this.billBasicConvert.billTaskVOToDTO(billTaskVOS));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5ba1\u6279\u5355", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"/all/bill"})
    public R<List<BillItemDTO>> forSelect(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String q = (String)params.get("q");
        String filterText = this.decode(q);
        DraftBillQuery query = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            query = (DraftBillQuery)JSON.parseObject((String)filterText, DraftBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findAllByQuery(pageNo, pageSize, query);
        List key = (List)result.getKey();
        return R.ok(this.billBasicConvert.billItemsVOToDTO(key), (Long)((Long)result.getValue()));
    }

    public BillListFeignController(BillLogic billLogic, BillTaskLogic billTaskLogic, BillBasicConvert billBasicConvert) {
        this.billLogic = billLogic;
        this.billTaskLogic = billTaskLogic;
        this.billBasicConvert = billBasicConvert;
    }
}

