/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.feign;

import cn.hutool.core.lang.Pair;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jingtong.bpm.facde.dto.BaseProcessDTO;
import com.jingtong.bpm.facde.dto.ProcessDTO;
import com.jingtong.bpm.facde.dto.ProcessGridDTO;
import com.jingtong.bpm.facde.dto.ProcessTypeDTO;
import com.jingtong.bpm.logic.converts.ProcessBasicConvert;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import com.jingtong.bpm.logic.service.ProcessFlowLogic;
import com.jingtong.bpm.logic.service.ProcessTypeLogic;
import com.jingtong.bpm.logic.vo.ProcessTypeVO;
import com.jingtong.bpm.logic.vo.ProcessVO;
import com.jingtong.data.rest.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/bill/process/feign"})
@RestController
@Api(tags={"\u6d41\u7a0b\u5217\u8868"})
public class BillProcessFeignController {
    private final ProcessTypeLogic processTypeLogic;
    private final LoginUserHolder loginUserHolder;
    private final ProcessFlowLogic processFlowLogic;
    private final ProcessBasicConvert processBasicConvert;

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u53d1\u8d77\u7684\u6d41\u7a0b\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"list/type"})
    public R<List<ProcessTypeDTO>> listType(String name) {
        String userCode = this.loginUserHolder.getUserCode();
        Set<String> userOrgs = this.loginUserHolder.getUserOrgs();
        String bloc = this.loginUserHolder.getBloc();
        List<ProcessTypeVO> processTypes = this.processTypeLogic.selectAllWithTypeGroup(userCode, userOrgs, bloc, Strings.isNullOrEmpty((String)name) ? "" : name);
        ArrayList result = Lists.newArrayList();
        for (ProcessTypeVO processType : processTypes) {
            List<ProcessVO> flows = processType.getFlows();
            List<ProcessDTO> a = this.processBasicConvert.processVOtoDTO(flows);
            ProcessTypeDTO processTypeDTO = this.processBasicConvert.processTypeVOToDTO(processType);
            processTypeDTO.setFlows(a);
            result.add(processTypeDTO);
        }
        return R.ok((Object)result);
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5206\u7c7b\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/type"})
    public R<List<ProcessTypeDTO>> allType() {
        List<ProcessTypeDTO> result = this.processTypeLogic.getAllType();
        return R.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6d41\u7a0b", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10")})
    @GetMapping(value={"/list"})
    public R<List<ProcessGridDTO>> grid(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String bloc = this.loginUserHolder.getBloc();
        Pair<List<ProcessGridDTO>, Long> pair = this.processFlowLogic.getProcessFlowByPage(pageNo, pageSize, params, bloc);
        return R.ok((Object)pair.getKey(), (Long)((Long)pair.getValue()));
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u57fa\u7840\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"info"})
    public R<BaseProcessDTO> detail(Long id) {
        BaseProcessDTO result = this.processFlowLogic.getBaseInfo(id);
        return R.ok((Object)result);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u57fa\u672c\u4fe1\u606f", httpMethod="POST")
    @PostMapping(value={"save"})
    public R save(@RequestBody BaseProcessDTO process) {
        String bloc = this.loginUserHolder.getBloc();
        return R.state((boolean)this.processFlowLogic.saveProcess(process, bloc));
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b", httpMethod="DELETE")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @DeleteMapping(value={"/{id}"})
    public R remove(@ApiIgnore @PathVariable(value="id", required=false) long processId) {
        return R.state((boolean)this.processFlowLogic.removeProcess(processId));
    }

    @ApiOperation(value="\u64a4\u56de\u6d41\u7a0b", httpMethod="PUT")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @PutMapping(value={"/cancel/{id}"})
    public R cancel(@ApiIgnore @PathVariable(value="id", required=false) long processId) {
        return R.state((boolean)this.processFlowLogic.cancelProcess(processId));
    }

    @ApiOperation(value="\u542f\u7528\u6d41\u7a0b", httpMethod="PUT")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @PutMapping(value={"/enable/{id}"})
    public R enable(@ApiIgnore @PathVariable(value="id", required=false) long processId) {
        return R.state((boolean)this.processFlowLogic.enableProcess(processId));
    }

    @ApiOperation(value="\u7981\u7528\u6d41\u7a0b", httpMethod="PUT")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @PutMapping(value={"/disable/{id}"})
    public R disable(@ApiIgnore @PathVariable(value="id", required=false) long processId) {
        return R.state((boolean)this.processFlowLogic.disableProcess(processId));
    }

    @ApiOperation(value="\u53d1\u5e03\u6d41\u7a0b", httpMethod="PUT")
    @ApiImplicitParam(name="id", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="Long")
    @PutMapping(value={"release/{id}"})
    public R release(@PathVariable(value="id") long processId) {
        return R.state((boolean)this.processFlowLogic.releaseProcess(processId));
    }

    @PutMapping(value={"/open/{id}"})
    public R open(@PathVariable(value="id") long processId) {
        boolean openState = this.processFlowLogic.openProcess(processId);
        return R.state((boolean)openState);
    }

    @PutMapping(value={"/closed/{id}"})
    public R closed(@PathVariable(value="id") long processId) {
        boolean openState = this.processFlowLogic.closeProcess(processId);
        return R.state((boolean)openState);
    }

    @GetMapping(value={"/print/tmp"})
    public R printTmp(Long id) {
        return R.ok((Object)this.processFlowLogic.getPrintTmp(id));
    }

    public BillProcessFeignController(ProcessTypeLogic processTypeLogic, LoginUserHolder loginUserHolder, ProcessFlowLogic processFlowLogic, ProcessBasicConvert processBasicConvert) {
        this.processTypeLogic = processTypeLogic;
        this.loginUserHolder = loginUserHolder;
        this.processFlowLogic = processFlowLogic;
        this.processBasicConvert = processBasicConvert;
    }
}

