/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.page;

import com.google.common.base.Strings;
import com.jingtong.bpm.logic.service.UserCenterlogic;
import com.jingtong.config.BpmConfig;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/process/bill/page"})
public class ProcessBillPageController {
    private static final Logger log = LoggerFactory.getLogger(ProcessBillPageController.class);
    private final UserCenterlogic userFeignClient;
    private final BpmConfig bpmConfig;

    @GetMapping(value={"/create"})
    public String createBill(Long processId, String key, String mode, HttpServletRequest request, Model model, Long billId, HttpServletResponse response) {
        boolean hasToken = ProcessBillPageController.isHasToken(request);
        if (!hasToken) {
            String tokenByKey = this.userFeignClient.getTokenByKey(key);
            if (Strings.isNullOrEmpty((String)tokenByKey)) {
                return "404";
            }
            Cookie cookie = new Cookie("token", tokenByKey.replace("bearer ", ""));
            cookie.setPath("/");
            cookie.setHttpOnly(false);
            cookie.setMaxAge(-1);
            response.addCookie(cookie);
            model.addAttribute("targetUrl", (Object)this.bpmConfig.getTargetUrl());
        }
        return "bill/create";
    }

    public static boolean isHasToken(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        boolean hasToken = false;
        if (!Objects.isNull(cookies)) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                if (!name.equals("token")) continue;
                hasToken = true;
            }
        }
        return false;
    }

    public ProcessBillPageController(UserCenterlogic userFeignClient, BpmConfig bpmConfig) {
        this.userFeignClient = userFeignClient;
        this.bpmConfig = bpmConfig;
    }
}

