/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.page;

import cn.hutool.core.util.StrUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.jingtong.bpm.facade.page.ProcessBillPageController;
import com.jingtong.bpm.logic.dto.FormDesingerDTO;
import com.jingtong.bpm.logic.dto.ProcessDesingerDTO;
import com.jingtong.bpm.logic.dto.ProcessDetailDTO;
import com.jingtong.bpm.logic.service.DataSourceLogic;
import com.jingtong.bpm.logic.service.ProcessDesingerLogic;
import com.jingtong.bpm.logic.service.UserCenterlogic;
import com.jingtong.bpm.logic.vo.DatasourceVO;
import com.jingtong.config.BpmConfig;
import com.jingtong.util.serialize.JsonMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/process/flow"})
public class ProcessDesingerPageController {
    private final UserCenterlogic userFeignClient;
    private static final String PROTYPE_JSON = "protype_json";
    private final ProcessDesingerLogic processLogic;
    private final DataSourceLogic dataSourceLogic;
    private final BpmConfig bpmConfig;

    @GetMapping(value={"designer"})
    public String index(@RequestParam(value="id", defaultValue="0") long processId, String key, HttpServletResponse response, HttpServletRequest request, Model model) {
        boolean hasToken = ProcessBillPageController.isHasToken(request);
        if (!hasToken) {
            String tokenByKey = this.userFeignClient.getTokenByKey(key);
            if (Strings.isNullOrEmpty((String)tokenByKey)) {
                return "404";
            }
            Cookie cookie = new Cookie("token", tokenByKey.replace("bearer ", ""));
            cookie.setPath("/");
            cookie.setHttpOnly(false);
            cookie.setMaxAge(-1);
            response.addCookie(cookie);
            model.addAttribute("type", (Object)this.bpmConfig.getType());
            model.addAttribute("targetUrl", (Object)this.bpmConfig.getTargetUrl());
        }
        if (processId < 0L) {
            model.addAttribute("error", (Object)"\u6d41\u7a0bid\u4e3a\u7a7a");
        } else {
            ProcessDetailDTO process = this.processLogic.getByProecessId(processId);
            if (process == null) {
                model.addAttribute("error", (Object)"\u65e0\u6cd5\u627e\u5230\u6d41\u7a0b");
            } else {
                String workflow;
                ProcessDesingerDTO desinger;
                String desingerJson;
                model.addAttribute("process", (Object)process);
                FormDesingerDTO formDesinger = this.processLogic.getDesingerJSON(processId);
                List<DatasourceVO> datasourceVOList = this.dataSourceLogic.getAllWithForm();
                String formJSON = "";
                if (formDesinger != null && !Strings.isNullOrEmpty((String)(desingerJson = formDesinger.getDesingerJson()))) {
                    formJSON = desingerJson;
                }
                if (Strings.isNullOrEmpty((String)formJSON)) {
                    HashMap vars = Maps.newHashMapWithExpectedSize((int)1);
                    vars.put("name", process.getName());
                    formJSON = StrUtil.format((CharSequence)"{\"columnItems\":[[{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null}],[{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null},{\"colspan\":1,\"rowspan\":1,\"widget\":null}]],\"attr\":{\"name\":\"{name}\",\"layout\":{\"width\":\"auto\",\"colgroup\":[{\"value\":100,\"type\":\"px\"},{\"value\":1,\"type\":\"flex\"},{\"value\":100,\"type\":\"px\"},{\"value\":1,\"type\":\"flex\"},{\"value\":100,\"type\":\"px\"},{\"value\":1,\"type\":\"flex\"}]},\"style\":{\"border\":true},\"icon\":0}}", (Map)vars);
                }
                if ((desinger = this.processLogic.getDesingerById(processId)) == null) {
                    HashMap vars = Maps.newHashMapWithExpectedSize((int)1);
                    vars.put("id", process.getId());
                    vars.put("name", process.getName());
                    vars.put("enable", process.getCloseFlag());
                    workflow = StrUtil.format((CharSequence)"{\"enable\":{enable},\"xml\":\"<?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?><definitions xmlns=\\\"http://www.omg.org/spec/BPMN/20100524/MODEL\\\" xmlns:bpmndi=\\\"http://www.omg.org/spec/BPMN/20100524/DI\\\" xmlns:omgdi=\\\"http://www.omg.org/spec/DD/20100524/DI\\\" xmlns:omgdc=\\\"http://www.omg.org/spec/DD/20100524/DC\\\" xmlns:xsi=\\\"http://www.w3.org/2001/XMLSchema-instance\\\" id=\\\"sid-{id}\\\" targetNamespace=\\\"http://bpmn.io/bpmn\\\" exporter=\\\"http://bpmn.io\\\" exporterVersion=\\\"0.10.1\\\"><process id=\\\"Process_{id}\\\" name=\\\"{name}\\\" isExecutable=\\\"true\\\"><startEvent id=\\\"StartEvent_1\\\" name=\\\"\u6d41\u7a0b\u5f00\u59cb\u8282\u70b9\\\"><outgoing>SequenceFlow_0pmgy78</outgoing></startEvent><endEvent id=\\\"EndEvent_1evstbh\\\" name=\\\"\u6d41\u7a0b\u7ed3\u675f\u8282\u70b9\\\"><incoming>SequenceFlow_0pmgy78</incoming></endEvent><sequenceFlow id=\\\"SequenceFlow_0pmgy78\\\" sourceRef=\\\"StartEvent_1\\\" targetRef=\\\"EndEvent_1evstbh\\\" /></process><bpmndi:BPMNDiagram id=\\\"BpmnDiagram_1\\\"><bpmndi:BPMNPlane id=\\\"BpmnPlane_1\\\" bpmnElement=\\\"Process_1\\\"><bpmndi:BPMNShape id=\\\"StartEvent_1_gui\\\" bpmnElement=\\\"StartEvent_1\\\"><omgdc:Bounds x=\\\"343\\\" y=\\\"123\\\" width=\\\"30\\\" height=\\\"30\\\" /><bpmndi:BPMNLabel><omgdc:Bounds x=\\\"263\\\" y=\\\"131\\\" width=\\\"66\\\" height=\\\"13\\\" /></bpmndi:BPMNLabel></bpmndi:BPMNShape><bpmndi:BPMNShape id=\\\"EndEvent_1evstbh_di\\\" bpmnElement=\\\"EndEvent_1evstbh\\\"><omgdc:Bounds x=\\\"340.26428571428573\\\" y=\\\"347\\\" width=\\\"36\\\" height=\\\"36\\\" /><bpmndi:BPMNLabel><omgdc:Bounds x=\\\"262\\\" y=\\\"358\\\" width=\\\"66\\\" height=\\\"13\\\" /></bpmndi:BPMNLabel></bpmndi:BPMNShape><bpmndi:BPMNEdge id=\\\"SequenceFlow_0pmgy78_di\\\" bpmnElement=\\\"SequenceFlow_0pmgy78\\\"><omgdi:waypoint xsi:type=\\\"omgdc:Point\\\" x=\\\"358\\\" y=\\\"153\\\" /><omgdi:waypoint xsi:type=\\\"omgdc:Point\\\" x=\\\"358\\\" y=\\\"347\\\" /><bpmndi:BPMNLabel><omgdc:Bounds x=\\\"373\\\" y=\\\"243\\\" width=\\\"0\\\" height=\\\"13\\\"/></bpmndi:BPMNLabel></bpmndi:BPMNEdge></bpmndi:BPMNPlane></bpmndi:BPMNDiagram></definitions>\",\"nodeSettings\":[{\"ntype\":\"start\",\"nodeId\":\"StartEvent_1\",\"title\":\"\u6d41\u7a0b\u5f00\u59cb\u8282\u70b9\",\"desc\":\"\"},{\"ntype\":\"line\",\"nodeId\":\"SequenceFlow_0pmgy78\",\"title\":\"\",\"desc\":\"\"},{\"ntype\":\"end\",\"nodeId\":\"EndEvent_1evstbh\",\"title\":\"\u6d41\u7a0b\u7ed3\u675f\u8282\u70b9\",\"desc\":\"\"}],\"attr\":{\"allowRevoke\":false}}", (Map)vars);
                } else {
                    workflow = desinger.getDesingerJson();
                }
                model.addAttribute("formJSON", (Object)formJSON);
                model.addAttribute("datasources", (Object)JsonMapper.toJson(datasourceVOList));
                model.addAttribute("positsions", (Object)"[]");
                model.addAttribute("icons", (Object)"[]");
                model.addAttribute("workflow", (Object)workflow);
            }
        }
        return "process/designer";
    }

    @GetMapping(value={"line"})
    public String line(Model model) {
        String jsonProjectTypes = this.getProjectCategorys();
        model.addAttribute(PROTYPE_JSON, (Object)jsonProjectTypes);
        return "process/line";
    }

    @GetMapping(value={"cc"})
    public String cc(Model model) {
        String jsonProjectTypes = this.getProjectCategorys();
        model.addAttribute(PROTYPE_JSON, (Object)jsonProjectTypes);
        return "process/cc";
    }

    @GetMapping(value={"approver"})
    public String approver(Model model) {
        String jsonProjectTypes = this.getProjectCategorys();
        model.addAttribute(PROTYPE_JSON, (Object)jsonProjectTypes);
        return "process/approver";
    }

    private String getProjectCategorys() {
        String jsonProjectTypes = "[]";
        return jsonProjectTypes;
    }

    public ProcessDesingerPageController(UserCenterlogic userFeignClient, ProcessDesingerLogic processLogic, DataSourceLogic dataSourceLogic, BpmConfig bpmConfig) {
        this.userFeignClient = userFeignClient;
        this.processLogic = processLogic;
        this.dataSourceLogic = dataSourceLogic;
        this.bpmConfig = bpmConfig;
    }
}

