/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import com.google.common.collect.Maps;
import com.jingtong.bpm.logic.dto.AttachmentDTO;
import com.jingtong.bpm.logic.service.FileUploadLogic;
import com.jingtong.data.rest.R;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/bill/file/rest"})
public class BillFileController {
    private final FileUploadLogic fileUploadLogic;

    @PostMapping(value={"/upload"})
    public R upload(@RequestParam(value="file") MultipartFile var1) {
        AttachmentDTO data = this.fileUploadLogic.upload(var1);
        if (!Objects.isNull(data)) {
            HashMap result = Maps.newHashMap();
            result.put("fileName", data.getName());
            result.put("filePath", data.getUrl());
            result.put("fileSize", data.getSize());
            result.put("id", data.getId());
            result.put("fileType", data.getType());
            result.put("url", data.getId());
            return R.ok((Object)result);
        }
        return R.empty();
    }

    @GetMapping(value={"/download/{id}"})
    public void download(@PathVariable(value="id") Long id, HttpServletResponse resp) {
        InputStream inputStream = this.fileUploadLogic.download(id);
        String fileName = "\u672a\u77e5\u540d\u79f0";
        try {
            AttachmentDTO fileInfo = this.fileUploadLogic.getFileInfo(id);
            if (!Objects.isNull(fileInfo)) {
                fileName = fileInfo.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            int len;
            String filename = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
            resp.setHeader("Content-Disposition", "attachment;filename=" + filename);
            ServletOutputStream servletOutputStream = resp.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > 0) {
                servletOutputStream.write(buffer, 0, len);
            }
            servletOutputStream.flush();
            inputStream.close();
            servletOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BillFileController(FileUploadLogic fileUploadLogic) {
        this.fileUploadLogic = fileUploadLogic;
    }
}

