/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import cn.hutool.core.util.StrUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.jingtong.bpm.logic.dto.BillActionParamDTO;
import com.jingtong.bpm.logic.dto.ValidationResultDTO;
import com.jingtong.bpm.logic.error.BillCode;
import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.bpm.logic.service.BillNextNodeLogic;
import com.jingtong.bpm.logic.service.BillPrintLogic;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import com.jingtong.bpm.logic.vo.BillApprovalHistoryVO;
import com.jingtong.bpm.logic.vo.BillItemVO;
import com.jingtong.data.exception.RbException;
import com.jingtong.data.rest.R;
import com.jingtong.util.error.ErrorCode;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bill/flow/rest"})
public class BillFlowRestController {
    private final BillLogic billLogic;
    private final LoginUserHolder loginUserHolder;
    private final BillNextNodeLogic billNextNodeLogic;
    private final BillPrintLogic billPrintLogic;

    @PostMapping(value={"drafts"})
    public R drafts(@RequestParam(value="processId") long processId, @RequestParam(value="id", required=false, defaultValue="0") long billId, @RequestParam(value="formData") String formData) {
        BillItemVO billItem = this.billLogic.saveDrafts(processId, billId, formData);
        return R.ok((Object)billItem);
    }

    @PostMapping(value={"submit"})
    public R submit(@RequestParam(value="processId") long processId, @RequestParam(value="billId", required=false, defaultValue="0") long billId, @RequestParam(value="formData") String formData, @RequestParam(value="nextApprover", required=false) String nextApprover) {
        BillItemVO billItem = this.billLogic.startFlow(processId, billId, formData, nextApprover, "");
        return R.ok((Object)billItem);
    }

    @PostMapping(value={"send"})
    public R<BillItemVO> send(@RequestParam(value="processId") long processId, @RequestParam(value="nextApprover", required=false) String nextApprover, @RequestParam(value="billId") long billId) {
        BillItemVO billItem = this.billLogic.sendProcess(billId, processId, nextApprover);
        return R.ok((Object)billItem);
    }

    @PostMapping(value={"agree"})
    public R agree(@RequestParam(value="billId") long billId, @RequestParam(value="taskId", defaultValue="0") String taskId, @RequestParam(value="content") String opinion, @RequestParam(value="nextApprover", required=false) String nextApproverStr, @RequestParam(value="formData", required=false) String formData) {
        if (Strings.isNullOrEmpty((String)nextApproverStr) || StrUtil.equals((CharSequence)nextApproverStr, (CharSequence)"undefined")) {
            nextApproverStr = "0";
        }
        String userCode = this.loginUserHolder.getUserCode();
        BillActionParamDTO actionParam = BillActionParamDTO.builder().billId(billId).userCode(userCode).taskId(taskId).opinion(opinion).formData(formData).nextApprover(nextApproverStr).build();
        this.billLogic.agreeFlow(actionParam);
        return R.empty();
    }

    @PostMapping(value={"turn"})
    public R turn(@RequestParam(value="billId") long billId, @RequestParam(value="taskId", defaultValue="0") String taskId, @RequestParam(value="content", required=false, defaultValue="") String opinion, @RequestParam(value="turnUser") String turnUser) {
        String userCode = this.loginUserHolder.getUserCode();
        this.billLogic.turnUser(billId, taskId, turnUser, userCode, opinion);
        return R.empty();
    }

    @PostMapping(value={"endorse"})
    public R endorse(@RequestParam(value="billId") long billId, @RequestParam(value="taskId", defaultValue="0") String taskId, @RequestParam(value="content") String opinion, @RequestParam(value="nextApprover") String endorseApproverStr, @RequestParam(value="formData", required=false) String formData) {
        String userCode = this.loginUserHolder.getUserCode();
        if (userCode.equals(endorseApproverStr)) {
            throw new RbException((ErrorCode)BillCode.ENDORSE_CANNOT_SELF);
        }
        BillActionParamDTO actionParam = BillActionParamDTO.builder().billId(billId).userCode(userCode).taskId(taskId).opinion(opinion).formData(formData).endorseApprover(endorseApproverStr).build();
        this.billLogic.endorse(actionParam);
        return R.empty();
    }

    @PostMapping(value={"refuse"})
    public R refuse(@RequestParam(value="billId") long billId, @RequestParam(value="content") String opinion, @RequestParam(value="taskId", defaultValue="0") String taskId, @RequestParam(value="formData", required=false) String formData) {
        String userCode = this.loginUserHolder.getUserCode();
        BillActionParamDTO actionParam = BillActionParamDTO.builder().billId(billId).userCode(userCode).taskId(taskId).opinion(opinion).formData(formData).build();
        this.billLogic.refuseFlow(actionParam);
        return R.empty();
    }

    @PostMapping(value={"repulse"})
    public R repulse(@RequestParam(value="billId") long billId, @RequestParam(value="content") String opinion, @RequestParam(value="taskId", defaultValue="0") String taskId, @RequestParam(value="targetTaskId", defaultValue="0") String targetTaskId, @RequestParam(value="nextApprover", defaultValue="0", required=false) String nextApprover, @RequestParam(value="formData", required=false) String formData) {
        String userCode = this.loginUserHolder.getUserCode();
        BillActionParamDTO actionParam = BillActionParamDTO.builder().billId(billId).userCode(userCode).nextApprover(nextApprover).taskId(taskId).opinion(opinion).formData(formData).targetTaskId(targetTaskId).build();
        this.billLogic.repulseFlow(actionParam);
        return R.empty();
    }

    @PostMapping(value={"cancel"})
    public R cancel(@RequestParam(value="billId") long billId, @RequestParam(value="content") String opinion, @RequestParam(value="taskId", defaultValue="0") String taskId) {
        String userCode = this.loginUserHolder.getUserCode();
        BillActionParamDTO actionParam = BillActionParamDTO.builder().billId(billId).userCode(userCode).taskId(taskId).opinion(opinion).build();
        this.billLogic.recallFlow(actionParam);
        return R.empty();
    }

    @GetMapping(value={"approval/history"})
    public R<List<BillApprovalHistoryVO>> approvalHistory(@RequestParam(value="billId") long billId) {
        List<BillApprovalHistoryVO> approvalHistorys = this.billLogic.findBillApprovalHistory(billId);
        return R.ok(approvalHistorys);
    }

    @PostMapping(value={"manual/flag"})
    public R manualFlag(@RequestParam(value="billId") long billId, @RequestParam(value="taskId", defaultValue="0") String taskId, @RequestParam(value="formData", required=false) String formData) {
        Pair<Integer, String> manualFlag = this.billNextNodeLogic.approvalNextManualFlag(taskId, billId, formData);
        HashMap result = Maps.newHashMap();
        result.put("manualFlag", manualFlag.getKey());
        result.put("nodeName", manualFlag.getValue());
        return R.ok((Object)result);
    }

    @PostMapping(value={"manual/flag/submit"})
    public R manualSubmitFlag(@RequestParam(value="processId", defaultValue="0") Long processId, @RequestParam(value="formData", required=false) String formData) {
        String userId = this.loginUserHolder.getUserCode();
        Pair<Integer, String> manualFlag = this.billNextNodeLogic.submitNextManualFlag(processId, userId, formData);
        HashMap result = Maps.newHashMap();
        result.put("manualFlag", manualFlag.getKey());
        result.put("nodeName", manualFlag.getValue());
        return R.ok((Object)result);
    }

    @GetMapping(value={"/download"})
    public void download(@RequestParam(value="billId") Long billId, HttpServletResponse resp, HttpServletRequest request) {
        this.billPrintLogic.download(billId, resp, request);
    }

    @GetMapping(value={"/print"})
    public R print(@RequestParam(value="billId") Long billId) {
        return R.ok((Object)this.billPrintLogic.print(billId));
    }

    @PostMapping(value={"validation"})
    public R<ValidationResultDTO> validation(@RequestParam(value="processId") long processId, @RequestParam(value="billId", required=false, defaultValue="0") long billId, @RequestParam(value="formData") String formData) {
        ValidationResultDTO validationResultDto = this.billLogic.validation(processId, billId, formData, this.loginUserHolder.getUserCode());
        return R.ok((Object)validationResultDto);
    }

    @GetMapping(value={"/node/condition"})
    public R<List<String>> getNodeCondition(@RequestParam(value="processId") long processId, @RequestParam(value="billId", required=false, defaultValue="0") long billId, @RequestParam(value="taskId", required=true, defaultValue="0") String taskId) {
        List<String> result = this.billLogic.getNodeCondition(processId, billId, taskId);
        return R.ok(result);
    }

    public BillFlowRestController(BillLogic billLogic, LoginUserHolder loginUserHolder, BillNextNodeLogic billNextNodeLogic, BillPrintLogic billPrintLogic) {
        this.billLogic = billLogic;
        this.loginUserHolder = loginUserHolder;
        this.billNextNodeLogic = billNextNodeLogic;
        this.billPrintLogic = billPrintLogic;
    }
}

