/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.jingtong.bpm.facde.dto.BillTaskDTO;
import com.jingtong.bpm.logic.converts.BillBasicConvert;
import com.jingtong.bpm.logic.query.list.ApprovedBillQuery;
import com.jingtong.bpm.logic.query.list.CcBillQuery;
import com.jingtong.bpm.logic.query.list.DraftBillQuery;
import com.jingtong.bpm.logic.query.list.MeCreateBillQuery;
import com.jingtong.bpm.logic.query.list.TodoBillQuery;
import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.bpm.logic.service.BillTaskLogic;
import com.jingtong.bpm.logic.vo.BillItemVO;
import com.jingtong.bpm.logic.vo.BillTaskVO;
import com.jingtong.data.rest.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/bill/list/rest"})
@RestController
@Api(tags={"\u5ba1\u6279\u5355\u5217\u8868"})
public class BillListRestController {
    private final BillLogic billLogic;
    private final BillTaskLogic billTaskLogic;
    private final BillBasicConvert billBasicConvert;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6211\u5df2\u5ba1\u6279\u7684\u5ba1\u6279\u5355", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"approved"})
    public R<List<BillItemVO>> approved(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String filterText = (String)params.get("q");
        ApprovedBillQuery query = !Strings.isNullOrEmpty((String)filterText) ? (ApprovedBillQuery)JSON.parseObject((String)filterText, ApprovedBillQuery.class) : new ApprovedBillQuery();
        Pair<List<BillItemVO>, Long> result = this.billLogic.findApproved(pageNo, pageSize, query);
        return R.ok((Object)result.getKey(), (Long)((Long)result.getValue()));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f85\u6211\u5ba1\u6279\u7684\u5ba1\u6279\u5355", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"/todo"})
    public R<List<BillItemVO>> todo(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String filterText = (String)params.get("q");
        TodoBillQuery query = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            query = (TodoBillQuery)JSON.parseObject((String)filterText, TodoBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findTodo(pageNo, pageSize, query);
        return R.ok((Object)result.getKey(), (Long)((Long)result.getValue()));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6211\u53d1\u8d77\u7684\u5ba1\u6279", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"/minecreate"})
    public R<List<BillItemVO>> sended(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String filterText = (String)params.get("q");
        MeCreateBillQuery billQuery = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            billQuery = (MeCreateBillQuery)JSON.parseObject((String)filterText, MeCreateBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findMeCreate(pageNo, pageSize, billQuery);
        return R.ok((Object)result.getKey(), (Long)((Long)result.getValue()));
    }

    @GetMapping(value={"/drafts"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6211\u7684\u8349\u7a3f\u5ba1\u6279", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    public R<List<BillItemVO>> drafts(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String filterText = (String)params.get("q");
        DraftBillQuery query = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            query = (DraftBillQuery)JSON.parseObject((String)filterText, DraftBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findDraft(pageNo, pageSize, query);
        return R.ok((Object)result.getKey(), (Long)((Long)result.getValue()));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6284\u9001\u6211\u7684\u5ba1\u6279", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"/cc"})
    public R<List<BillItemVO>> cc(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String filterText = (String)params.get("q");
        CcBillQuery query = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            query = (CcBillQuery)JSON.parseObject((String)filterText, CcBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findCc(pageNo, pageSize, query);
        return R.ok((Object)result.getKey(), (Long)((Long)result.getValue()));
    }

    @GetMapping(value={"/history/tasks"})
    public R<List<BillTaskDTO>> getHistoryTasks(Long billId) {
        List<BillTaskVO> billTaskVOS = this.billTaskLogic.getHistoryTasks(billId);
        return R.ok(this.billBasicConvert.billTaskVOToDTO(billTaskVOS));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5ba1\u6279\u5355", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10"), @ApiImplicitParam(name="q", value="\u67e5\u8be2\u53c2\u6570", defaultValue="")})
    @GetMapping(value={"/all/bill"})
    public R<List<BillItemVO>> forSelect(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        String filterText = (String)params.get("q");
        DraftBillQuery query = null;
        if (!Strings.isNullOrEmpty((String)filterText)) {
            query = (DraftBillQuery)JSON.parseObject((String)filterText, DraftBillQuery.class);
        }
        Pair<List<BillItemVO>, Long> result = this.billLogic.findAllByQuery(pageNo, pageSize, query);
        return R.ok((Object)result.getKey(), (Long)((Long)result.getValue()));
    }

    public BillListRestController(BillLogic billLogic, BillTaskLogic billTaskLogic, BillBasicConvert billBasicConvert) {
        this.billLogic = billLogic;
        this.billTaskLogic = billTaskLogic;
        this.billBasicConvert = billBasicConvert;
    }
}

