/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import com.google.common.base.Strings;
import com.jingtong.bpm.logic.service.BillLogic;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import com.jingtong.bpm.logic.service.ProcessTypeLogic;
import com.jingtong.bpm.logic.vo.BillApprovalHistoryVO;
import com.jingtong.bpm.logic.vo.BillDetailVO;
import com.jingtong.bpm.logic.vo.FormFieldVO;
import com.jingtong.bpm.logic.vo.ProcessTypeVO;
import com.jingtong.data.rest.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bill/process/rest"})
@Api(tags={"\u53d1\u8d77\u5ba1\u6279"})
public class BillProcessRestController {
    private final ProcessTypeLogic processTypeLogic;
    private final BillLogic billLogic;
    private final LoginUserHolder loginUserHolder;

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u53d1\u8d77\u7684\u6d41\u7a0b\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"list/type"})
    public R<List<ProcessTypeVO>> listType(String name) {
        String userCode = this.loginUserHolder.getUserCode();
        Set<String> userOrgs = this.loginUserHolder.getUserOrgs();
        String bloc = this.loginUserHolder.getBloc();
        List<ProcessTypeVO> processTypes = this.processTypeLogic.selectAllWithTypeGroup(userCode, userOrgs, bloc, Strings.isNullOrEmpty((String)name) ? "" : name);
        return R.ok(processTypes);
    }

    @GetMapping(value={"create/{processId}"})
    public R create(@PathVariable(value="processId") long processId, @RequestParam(value="app", required=false, defaultValue="0") Integer app) {
        if (app == 1) {
            BillDetailVO<List<FormFieldVO>> billDetailVO = this.billLogic.createByApp(processId);
            return R.ok(billDetailVO);
        }
        BillDetailVO billDetailVO = this.billLogic.create(processId);
        return R.ok((Object)billDetailVO);
    }

    @GetMapping(value={"edit/{billId}"})
    public R edit(@PathVariable(value="billId") long billId, @RequestParam(value="page", required=false, defaultValue="edit") String page) {
        BillDetailVO billDetailVO = this.billLogic.findBillDetail(billId, page);
        if (null == billDetailVO) {
            return R.empty();
        }
        List<BillApprovalHistoryVO> approvalHistorys = this.billLogic.findBillApprovalHistory(billId);
        billDetailVO.setTrack(approvalHistorys);
        return R.ok((Object)billDetailVO);
    }

    @GetMapping(value={"view/{billId}"})
    public R view(@PathVariable(value="billId") long billId, @RequestParam(value="page", required=false, defaultValue="view") String page) {
        BillDetailVO billDetailVO = this.billLogic.findBillDetailModeView(billId, page);
        if (null == billDetailVO) {
            return R.empty();
        }
        List<BillApprovalHistoryVO> approvalHistorys = this.billLogic.findBillApprovalHistory(billId);
        billDetailVO.setTrack(approvalHistorys);
        return R.ok((Object)billDetailVO);
    }

    @GetMapping(value={"read/{billId}"})
    public R read(@PathVariable(value="billId") long billId) {
        boolean readState = this.billLogic.readBill(billId);
        return R.state((boolean)readState);
    }

    public BillProcessRestController(ProcessTypeLogic processTypeLogic, BillLogic billLogic, LoginUserHolder loginUserHolder) {
        this.processTypeLogic = processTypeLogic;
        this.billLogic = billLogic;
        this.loginUserHolder = loginUserHolder;
    }
}

