/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import cn.hutool.core.lang.Pair;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.jingtong.bpm.logic.dto.BillReplyDTO;
import com.jingtong.bpm.logic.service.BillReplyLogic;
import com.jingtong.data.rest.R;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bill/reply/rest"})
public class BillReplyRestController {
    private final BillReplyLogic billReplyLogic;

    @GetMapping(value={"/list"})
    public R<Map<String, Object>> list(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="billId") Long billId) {
        Pair<List<BillReplyDTO>, Long> billReplies = this.billReplyLogic.findByBillId(page, pageSize, billId);
        HashMap result = Maps.newHashMap();
        result.put("recordsTotal", billReplies.getValue());
        result.put("recordsFiltered", billReplies.getValue());
        result.put("data", billReplies.getKey());
        return R.ok((Object)result);
    }

    @PostMapping(value={"/delete"})
    public R delete(@RequestParam(value="replyId") long replyId, @RequestParam(value="billId") long billId) {
        boolean billReplies = this.billReplyLogic.deleteByBillId(billId, replyId);
        return R.state((boolean)billReplies);
    }

    @PostMapping(value={"/submit"})
    public R<BillReplyDTO> submit(@RequestParam(value="billId") Long billId, @RequestParam(value="content") String content) {
        BillReplyDTO replyDto = this.billReplyLogic.submit(billId, content);
        if (Strings.isNullOrEmpty((String)content)) {
            return R.empty();
        }
        if (replyDto == null) {
            return R.empty();
        }
        return R.ok((Object)replyDto);
    }

    public BillReplyRestController(BillReplyLogic billReplyLogic) {
        this.billReplyLogic = billReplyLogic;
    }
}

