/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.bpm.facade.rest;

import cn.hutool.core.lang.Pair;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.jingtong.bpm.facde.dto.DatasourceDTO;
import com.jingtong.bpm.logic.constant.ProcessCode;
import com.jingtong.bpm.logic.dto.DataSourceFormDTO;
import com.jingtong.bpm.logic.dto.DataTablesInputDTO;
import com.jingtong.bpm.logic.dto.DataTablesOutputDTO;
import com.jingtong.bpm.logic.dto.DatasourceComboDTO;
import com.jingtong.bpm.logic.dto.DatasourceConditionDTO;
import com.jingtong.bpm.logic.dto.DatasourcePopoverDTO;
import com.jingtong.bpm.logic.dto.ZZTableField;
import com.jingtong.bpm.logic.service.DataSourceLogic;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import com.jingtong.bpm.logic.vo.DatasourceVO;
import com.jingtong.data.exception.RbException;
import com.jingtong.data.rest.R;
import com.jingtong.util.error.ErrorCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/datasource/rest"})
@Api(tags={"\u6570\u636e\u6e90"})
public class DataSourceRestController {
    private final DataSourceLogic dataSourceLogic;
    private final LoginUserHolder loginUserHolder;

    @ApiOperation(value="\u6570\u636e\u6e90id\u83b7\u53d6\u4e0b\u62c9\u6846\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u636e\u6e90id", required=true, paramType="path", dataType="Long")})
    @GetMapping(value={"/combo/{id}"})
    public R<DatasourceComboDTO> getCombo(@ApiIgnore @PathVariable(value="id", required=false) long id) {
        if (id <= 0L) {
            return R.empty();
        }
        DatasourceComboDTO datasourceCombo = this.dataSourceLogic.getComboByDatasourceId(id);
        return R.ok((Object)datasourceCombo);
    }

    @ApiOperation(value="\u901a\u8fc7\u6570\u636e\u6e90id\u83b7\u53d6\u6761\u4ef6\u503c", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u636e\u6e90id", required=true, paramType="path", dataType="Long")})
    @GetMapping(value={"/condition/{id}"})
    public R<List<DatasourceConditionDTO>> getCondition(@ApiIgnore @PathVariable(value="id", required=false) long id) {
        if (id <= 0L) {
            return R.empty();
        }
        List<DatasourceConditionDTO> datasourceConditionss = this.dataSourceLogic.getConditionByDataSourceId(id);
        return R.ok(datasourceConditionss);
    }

    @ApiOperation(value="\u901a\u8fc7\u6570\u636e\u6e90id\u83b7\u53d6\u5f39\u51fa\u6846\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u636e\u6e90id", required=true, paramType="path", dataType="Long")})
    @GetMapping(value={"/popover/{id}"})
    public R<DatasourcePopoverDTO> get(@ApiIgnore @PathVariable(value="id", required=false) long id) {
        if (id <= 0L) {
            R.empty();
        }
        DatasourcePopoverDTO datasourcePopover = this.dataSourceLogic.getPopoverByDataSourceId(id);
        return R.ok((Object)datasourcePopover);
    }

    @ApiOperation(value="\u83b7\u53d6sql\u67e5\u8be2\u5217")
    @PostMapping(value={"/sqlfields"})
    public R<List<ZZTableField>> sqlfields(@RequestBody Map<String, Object> data) {
        String sqlscript = (String)data.get("sqlscript");
        Long dataSourceId = 0L;
        if (!Objects.isNull(data.get("id"))) {
            dataSourceId = Long.valueOf(data.get("id").toString());
        }
        if (Strings.isNullOrEmpty((String)sqlscript)) {
            return R.empty();
        }
        try {
            sqlscript = sqlscript.replace("${WHERE_PARAMS}", "");
            this.dataSourceLogic.executeSql(sqlscript, "", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.error((ErrorCode)ProcessCode.DELETE_DS_ERROR, (String)"\u6570\u636e\u5e93\u6267\u884c\u9519\u8bef,\u8bf7\u68c0\u67e5sql\u811a\u672c");
        }
        List<ZZTableField> tableFields = this.dataSourceLogic.getSqlSelectColumns(sqlscript, dataSourceId);
        return R.ok(tableFields);
    }

    @GetMapping(value={"/table/filed"})
    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u8868\u7684\u5b57\u6bb5\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="table_name", value="\u8868\u540d", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="id", value="\u636e\u6e90id", required=true, paramType="query", dataType="Long")})
    public R<List<ZZTableField>> fields(@RequestParam(value="table_name") String tableName, @RequestParam(value="id", required=false, defaultValue="0") long dataSourceId) {
        List<ZZTableField> tableFields = this.dataSourceLogic.ganerateTableFields(tableName, dataSourceId);
        return R.ok(tableFields);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e\u6e90", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", defaultValue="1"), @ApiImplicitParam(name="limit", defaultValue="10")})
    @GetMapping(value={"/list"})
    public R<List<DatasourceDTO>> grid(@ApiIgnore @RequestParam Map<String, Object> params) {
        Integer pageNo = Integer.valueOf((String)params.get("page"));
        Integer pageSize = Integer.valueOf((String)params.get("limit"));
        Pair<List<DatasourceDTO>, Long> pair = this.dataSourceLogic.getDatasourceByPage(pageNo, pageSize);
        return R.ok((Object)pair.getKey(), (Long)((Long)pair.getValue()));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u6e90", httpMethod="POST")
    @PostMapping(value={"/save"})
    public R save(@Valid @RequestBody DataSourceFormDTO dataSourceFormDTO) {
        String userCode = this.loginUserHolder.getUserCode();
        try {
            boolean isOk = this.dataSourceLogic.saveDataSource(dataSourceFormDTO, userCode);
            return R.state((boolean)isOk);
        }
        catch (RbException e) {
            e.printStackTrace();
            return R.error((ErrorCode)ProcessCode.DS_SAVE_ERROR, (String)"\u6570\u636e\u6e90\u4fdd\u5b58\u9519\u8bef");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParam(name="id", value="id", required=true, paramType="path", dataType="String")
    @GetMapping(value={"/{id}"})
    public R<DataSourceFormDTO> detail(@ApiIgnore @PathVariable Long id) {
        if (id > 0L) {
            DataSourceFormDTO dataSourceFormDTO = this.dataSourceLogic.getDetailById(id);
            return R.ok((Object)dataSourceFormDTO);
        }
        return R.empty();
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u6e90")
    @ApiImplicitParam(name="ids", value="\u591a\u4e2aid\u9017\u53f7\u9694\u5f00", required=true, paramType="path", dataType="String")
    @DeleteMapping(value={"/delete/{ids}"})
    public R delete(@PathVariable String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        return R.state((boolean)this.dataSourceLogic.batchDeleteDatasource(list));
    }

    @ApiOperation(value="\u83b7\u53d6\u5e73\u53f0\u8868\u540d", httpMethod="GET")
    @GetMapping(value={"/tables"})
    public R getTables() {
        List<String> tables = this.dataSourceLogic.mysqlQueryTables();
        return R.ok(tables);
    }

    @PostMapping(value={"/triggerselect"})
    public DataTablesOutputDTO<Map<String, Object>> triggerselect(@RequestBody DataTablesInputDTO dataTablesInput) {
        Map queryMap;
        JSONObject params = dataTablesInput.getParams();
        if (params == null) {
            throw new RbException((ErrorCode)ProcessCode.CODE_EMPTY);
        }
        if (dataTablesInput.getLength() == -1) {
            dataTablesInput.setStart(0);
            dataTablesInput.setLength(Integer.MAX_VALUE);
        }
        int start = (Integer)MoreObjects.firstNonNull((Object)dataTablesInput.getStart(), (Object)0);
        int current = start / dataTablesInput.getLength();
        Page requestPage = new Page((long)current, (long)dataTablesInput.getLength().intValue());
        String table = params.getString("table");
        try {
            queryMap = (Map)params.get((Object)"query");
        }
        catch (Exception e) {
            throw new RbException("", (ErrorCode)ProcessCode.QUERY_JSON_ERROR);
        }
        this.dataSourceLogic.execWithSelect(table, queryMap, (Page<Map<String, Object>>)requestPage, this.loginUserHolder.getUserCode());
        DataTablesOutputDTO<Map<String, Object>> dataTablesOutput = new DataTablesOutputDTO<Map<String, Object>>();
        dataTablesOutput.setData(requestPage.getRecords());
        dataTablesOutput.setDraw(dataTablesInput.getDraw());
        dataTablesOutput.setRecordsTotal(requestPage.getTotal());
        dataTablesOutput.setRecordsFiltered(requestPage.getTotal());
        return dataTablesOutput;
    }

    @GetMapping(value={"/datasources"})
    public R<List<DatasourceVO>> datasource() {
        List<DatasourceVO> datasourceVOList = this.dataSourceLogic.getAllWithForm();
        return R.ok(datasourceVOList);
    }

    public DataSourceRestController(DataSourceLogic dataSourceLogic, LoginUserHolder loginUserHolder) {
        this.dataSourceLogic = dataSourceLogic;
        this.loginUserHolder = loginUserHolder;
    }
}

